#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ide.h"

#define SECTOR_SIZE 2048

#define IDE_IRQ_PRIMARY   14
#define IDE_IRQ_SECONDARY 15

#define ISO_PRIMARY_VOLUME_DESCRIPTOR 1

int main(void) {
    /*  */
    IDEDriver* driver = (IDEDriver *) malloc(sizeof(IDEDriver));
    IDEDriver_IDEDriver(driver, IDE_IRQ_PRIMARY, IDE_IRQ_SECONDARY);

    /* ATAPI foCX̌ */
    int controller, deviceNo;
    if ( !IDEDriver_findDevice(driver, DEVICE_ATAPI, 0x05, &controller, &deviceNo) ) {
        return -1;
    }

    /* IRQ ̎擾 */
    //byte irq = (controller == PRIMARY) ? IDE_IRQ_PRIMARY : IDE_IRQ_SECONDARY;

    /* ATAPI foCX̎gpJn */
    if ( !IDEDriver_selectDevice(driver, controller, deviceNo) ) {
        return -1;
    }

    /* {{[Lqq̓ǂݍ */
    PrimaryVolumeDescriptor* pvd = (PrimaryVolumeDescriptor*) malloc(sizeof(PrimaryVolumeDescriptor));
    IDEDriver_read(driver, 16, pvd, SECTOR_SIZE); /* 16ZN^[܂ł̓u[g̈Ȃ̂ */
    if (pvd->type[0] != ISO_PRIMARY_VOLUME_DESCRIPTOR || strncmp("CD001", pvd->id, 5) != 0) {
        return -1;
    }

    /* [gfBNgǂݍ */
    DirectoryEntry* root = (DirectoryEntry *)( pvd->root_directory_record );
    dword size = ((dword)((root->size_l + SECTOR_SIZE - 1) / SECTOR_SIZE)) * SECTOR_SIZE;
    byte* buffer = (byte *) malloc(size);
    IDEDriver_read(driver, root->extent_l, buffer, size);
    dword position;
    for (position = 0; position < size;) {
        DirectoryEntry* dir = (DirectoryEntry *) (buffer + position);
        if (dir->size_l == 0) {
            break;
        } else if (dir->directory == 0) {
            if (strncmp(dir->name, "HOGEHOGE.HRB", 12) == 0) {
                byte* data = (byte *) malloc(size);
                IDEDriver_read(driver, dir->extent_l, data, dir->size_l);
                return 0;
            }
        }
        position += dir->length;
    }
    free(buffer);

    return -1;
}
