/* timerƂ */

#include "bootpack.h"

#define PIT_CTRL	0x0043
#define PIT_CNT0	0x0040

struct TIMERCTL timerctl;

#define TIMER_FLAGS_ALLOC	1	/* mۂ */
#define TIMER_FLAGS_USING	2	/* ^C}쓮 */

void init_pit(void)
{
	int i;
	struct TIMER *t;

	/* PIT */
	io_out8(PIT_CTRL, 0x34);
	io_out8(PIT_CNT0, 0x9c);
	io_out8(PIT_CNT0, 0x2e);

	timerctl.count = 0;
	for (i = 0; i < MAX_TIMER; i++)
		timerctl.timers0[i].flags = 0;	/* gp */

	t = timer_alloc();	/* 1 */
	t->timeout = 0xffffffff;
	t->flags = TIMER_FLAGS_USING;
	t->next = 0;	/* Pc */
	timerctl.t0 = t;	/* PcȂ̂ɐ擪Blڂ */
	timerctl.next = t->timeout; /* lڂȂ̂ŁAԕ̎ */
	return;
}

struct TIMER *timer_alloc(void)
{
	int i;
	for(i = 0; i < MAX_TIMER; i++) {
		if (timerctl.timers0[i].flags == 0) {
			timerctl.timers0[i].flags = TIMER_FLAGS_ALLOC;	/* gp */
			return &timerctl.timers0[i];
		}
	}
	return 0;	/* Ȃ */
}

void timer_free(struct TIMER *timer)
{
	timer->flags = 0;	/* gp */
	return;
}

void timer_init(struct TIMER *timer, struct FIFO32 *fifo, int data)
{
	timer->fifo = fifo;
	timer->data = data;
	return;
}

void timer_settime(struct TIMER *timer, unsigned int timeout)
{
	int e;
	struct TIMER *t, *s;

	timer->timeout = timeout + timerctl.count;
	timer->flags = TIMER_FLAGS_USING;	/* gp */

	e = io_load_eflags();
	io_cli();

	t = timerctl.t0;
	if (timer->timeout <= t->timeout) {
		/* 擪ɓƂ */
		timerctl.t0 = timer;
		timer->next = t;	/* t */
		timerctl.next = timer->timeout;
		goto fin;
	}

	/* ǂɓ邩({Ƃ͂ƈႤ) */
	for (;;) {
		s = t;
		t = t->next;
		if (timer->timeout <= t->timeout) {
			s->next = timer;
			timer->next = t;
			goto fin;
		}
	}

fin:
	io_store_eflags(e);
	return;
}

void inthandler20(int *esp)
{
	struct TIMER *timer;
	char ts = 0;

	io_out8(PIC0_OCW2, 0x60);	/* IRQ-00tPICɒʒm */
	timerctl.count++;
	if (timerctl.next > timerctl.count)
		return;
	timer = timerctl.t0;	/* Ƃ肠擪̔Ԓntimerɂ */

	for (;;) {
		if (timer->timeout > timerctl.count)
			break;	/* ^C}쒆Ȃ̂flags`FbNȂ */
		/* ^CAEg */
		timer->flags = TIMER_FLAGS_ALLOC;
		if (timer != task_timer)
			fifo32_put(timer->fifo, timer->data);
		else
			ts = 1;
		timer = timer->next;
	}

	timerctl.t0 = timer;	/* 炵 */
	timerctl.next = timerctl.t0->timeout;

	if (ts)
		task_switch();

	return;
}
