/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

struct TSS32 {
	int backlink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
	int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
	int es, cs, ss, ds, fs, gs;
	int ldtr, iomap;
};

static unsigned char osakkielogo[3] = {0x80, 0x81, '\0'};

void taskswitch3(void);
void taskswitch4(void);

void make_window8(unsigned char *buf, int xsize, int ysize, char *title);
void make_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c);
void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l);

void task_b_main(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct FIFO32 fifo;
	struct TIMER *timer;
	int fifobuf[128], i;

	fifo32_init(&fifo, 128, fifobuf);
	timer = timer_alloc();
	timer_init(timer, &fifo, 1);
	timer_settime(timer, 400);

	boxfill8(binfo->vram, binfo->scrnx, COL8_0000FF, 0, 0, binfo->scrnx - 1, binfo->scrny - 1);
	boxfill8(binfo->vram, binfo->scrnx, COL8_FFFFFF, binfo->scrnx/2-8*10, binfo->scrny/2-100,  binfo->scrnx/2+8*10, binfo->scrny/2-84);
	putfonts8_asc(binfo->vram, binfo->scrnx, binfo->scrnx/2-8*9, binfo->scrny/2-100, COL8_0000FF, osakkielogo);
	putfonts8_asc(binfo->vram, binfo->scrnx, binfo->scrnx/2-8*5, binfo->scrny/2-100, COL8_0000FF, "OSAkkie froze!!");
	putfonts8_asc(binfo->vram, binfo->scrnx, binfo->scrnx/2-8*9+1, binfo->scrny/2-100, COL8_0000FF, osakkielogo);
	putfonts8_asc(binfo->vram, binfo->scrnx, binfo->scrnx/2-8*5+1, binfo->scrny/2-100, COL8_0000FF, "OSAkkie froze!!");
	putfonts8_asc(binfo->vram, binfo->scrnx, binfo->scrnx/2-8*12+1, binfo->scrny/2-68, COL8_FFFFFF, "Prease restart computer.");

	for (;;) {
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			io_stihlt();
		} else {
			i = fifo32_get(&fifo);
			io_sti();
			if (i == 1) {
				/* ^CAEg1 */
				boxfill8(binfo->vram, binfo->scrnx, COL8_0000FF, 0, 0, binfo->scrnx - 1, binfo->scrny - 1);
				putfonts8_asc(binfo->vram, binfo->scrnx, binfo->scrnx/2-8*3, binfo->scrny/2-8, COL8_FFFFFF, "");

				timer_init(timer, &fifo, 2);
				timer_settime(timer, 200);
			}
			if (i == 2) {
				/* ^CAEg2 */
				farjmp(0, 3 * 8);
			}
		}
	}
}

void HariMain(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct FIFO32 fifo;
	char s[40];
	int fifobuf[128], mx, my, i, cursor_x, cursor_c;
	struct TIMER *timer, *timer2, *timer3;
	unsigned int memtotal;
	struct MOUSE_DEC mdec;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHTCTL *shtctl;
	struct SHEET *sht_back, *sht_mouse, *sht_win;
	unsigned char *buf_back, buf_mouse[256], *buf_win;
	static char keytable[0x54] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0,   0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0,   0,   'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.'
	};
	struct TSS32 tss_a, tss_b;
	struct SEGMENT_DESCRIPTOR *gdt = (struct SEGMENT_DESCRIPTOR *) ADR_GDT;
	int task_b_esp;

/*
	static char font_mini_A[12] = {
		0x00, 0x30, 0x30, 0x48, 0x48, 0x48,
		0x48, 0x78,	0x48, 0x48, 0x48, 0x00
	};
*/

	init_gdtidt();
	init_pic();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	fifo32_init(&fifo, 128, fifobuf);
	init_pit();
	init_keyboard(&fifo, 256);
	enable_mouse(&fifo, 512, &mdec);
	io_out8(PIC0_IMR, 0xf8); /* PITPIC1ƃL[{[h(11111000) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */

	timer = timer_alloc();
	timer_init(timer, &fifo, 10);
	timer_settime(timer, 1000);
	timer2 = timer_alloc();
	timer_init(timer2, &fifo, 3);
	timer_settime(timer2, 300);
	timer3 = timer_alloc();
	timer_init(timer3, &fifo, 1);
	timer_settime(timer3, 50);

	memtotal = memtest(0x00400000,0xbfffffff);
	memman_init(memman);
	memman_free(memman, 0x00001000, 0x0009e000); /*	0x00001000 - 0x0009efff */
	memman_free(memman, 0x00400000, memtotal - 0x00400000);

	init_palette();
	shtctl = shtctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	sht_back  = sheet_alloc(shtctl);
	sht_mouse = sheet_alloc(shtctl);
	sht_win   = sheet_alloc(shtctl);
	buf_back  = (unsigned char *) memman_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	buf_win   = (unsigned char *) memman_alloc_4k(memman, 160 * 52);
	sheet_setbuf(sht_back,  buf_back,  binfo->scrnx, binfo->scrny, -1);	/* FȂ */
	sheet_setbuf(sht_mouse, buf_mouse, 16,  16, 99);	/* Fԍ99 */
	sheet_setbuf(sht_win,   buf_win,   160, 52, -1);	/* FȂ */
	init_screen8(buf_back, binfo->scrnx, binfo->scrny);
	init_mouse_cursor8(buf_mouse, 99/* wiF */);
	make_window8(buf_win, 160, 52, "OSAkkie");
	make_textbox8(sht_win, 8, 28, 144, 16, COL8_FFFFFF);
	cursor_x = 8;
	cursor_c = COL8_FFFFFF;
	sheet_slide(sht_back, 0, 0);
	mx = (binfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (binfo->scrny - 16) / 2;
	sheet_slide(sht_mouse, mx, my);
	sheet_slide(sht_win, 80, 72);
	sheet_updown(sht_back,  0);
	sheet_updown(sht_win, 1);
	sheet_updown(sht_mouse, 2);
	sprintf(s, "(%3d, %3d)", mx, my);
	putfonts8_asc(buf_back, binfo->scrnx, 0, 0, COL8_FFFFFF, s);
	sprintf(s, "Memory: %dKB   Free: %dKB", memtotal / 1000, memman_total(memman) / 1024);
	putfonts8_asc(buf_back, binfo->scrnx, 0, 32, COL8_FFFFFF, s);
	sheet_refresh(sht_back, 0, 0, binfo->scrnx, 48);


	tss_a.ldtr  = 0;
	tss_a.iomap = 0x40000000;
	tss_b.ldtr  = 0;
	tss_b.iomap = 0x40000000;
	set_segmdesc(gdt + 3, 103, (int) &tss_a, AR_TSS32);
	set_segmdesc(gdt + 4, 103, (int) &tss_b, AR_TSS32);
	load_tr(3 * 8);
	task_b_esp = memman_alloc_4k(memman, 64 * 1024) + 64 * 1024;

	tss_b.eip = (int) &task_b_main;
	tss_b.eflags = 0x00000202;
	tss_b.eax = 0;
	tss_b.ecx = 0;
	tss_b.edx = 0;
	tss_b.ebx = 0;
	tss_b.esp = task_b_esp;
	tss_b.ebp = 0;
	tss_b.esi = 0;
	tss_b.edi = 0;
	tss_b.es = 1 * 8;
	tss_b.cs = 2 * 8;
	tss_b.ss = 1 * 8;
	tss_b.ds = 1 * 8;
	tss_b.fs = 1 * 8;
	tss_b.gs = 1 * 8;

	for (;;) {
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			io_stihlt();
		} else {
			i = fifo32_get(&fifo);
			io_sti();
			if (256 <= i && i < 512) {
				/* L[{[h */
				sprintf(s, "%02X", i - 256);
				putfonts8_asc_sht(sht_back, 0, 16, COL8_FFFFFF, COL8_3A6EA5, s, 2);
				if (i < 256 + 0x54) {
					if (keytable[i - 256] && cursor_x < 144) {
						s[0] = keytable[i - 256];
						s[1] = 0;
						putfonts8_asc_sht(sht_win, cursor_x, 28, COL8_000000, COL8_FFFFFF, s, 1);
						cursor_x += 8;
					}
				}
				if (i == 256 + 0x0e && cursor_x > 8) {
					cursor_x -= 8;
					putfonts8_asc_sht(sht_win, cursor_x, 28, COL8_000000, COL8_FFFFFF, "  ", 2);
				}
				boxfill8(buf_win, sht_win->bxsize, cursor_c, cursor_x, 28, cursor_x + 1, 43);
				sheet_refresh(sht_win, cursor_x, 28, cursor_x + 1, 44);
			} else if (512 <= i && i < 768) {
				/* }EX */
				if (mouse_decode(&mdec, i - 512)) {
					sprintf(s, "[lcr %4d %4d]", mdec.x, mdec.y);
					if (mdec.btn & 0x01)
						s[1] = 'L';
					if (mdec.btn & 0x02)
						s[3] = 'R';
					if (mdec.btn & 0x04)
						s[2] = 'C';
					putfonts8_asc_sht(sht_back, 32, 16, COL8_FFFFFF, COL8_3A6EA5, s, 15);
					/* }EXړ */
					mx += mdec.x;
					my += mdec.y;
					if (mx < 0)
						mx = 0;
					if (my < 0)
						my = 0;
					if (mx > binfo->scrnx - 1)
						mx = binfo->scrnx - 1;
					if (my > binfo->scrny - 1)
						my = binfo->scrny - 1;
					sprintf(s, "(%3d, %3d)", mx, my);
					putfonts8_asc_sht(sht_back, 0, 0, COL8_FFFFFF, COL8_3A6EA5, s, 10);
					sheet_slide(sht_mouse, mx, my);
					if (mdec.btn & 0x01) {
						sheet_slide(sht_win, mx - 80, my - 8);
					}
				}
			} else if (i == 10) {
				/* 10b^C} */
				putfonts8_asc_sht(sht_back, 0, 64, COL8_FFFFFF, COL8_3A6EA5, "10sec", 5);
				farjmp(0, 4 * 8);
			} else if (i == 3) {
				/* 3b^C} */
				putfonts8_asc_sht(sht_back, 0, 80, COL8_FFFFFF, COL8_3A6EA5, "3sec", 4);
			} else if (i <= 1) {
				/* J[\p */
				if (i) {
					timer_init(timer3, &fifo, 0);	/* 0 */
					cursor_c = COL8_000000;
				} else {
					timer_init(timer3, &fifo, 1);	/* 1 */
					cursor_c = COL8_FFFFFF;
				}
				timer_settime(timer3, 50);
				boxfill8(buf_win, sht_win->bxsize, cursor_c, cursor_x, 28, cursor_x + 1, 43);
				sheet_refresh(sht_win, cursor_x, 28, cursor_x + 1, 44);
			}
		}
	}
}

void make_window8(unsigned char *buf, int xsize, int ysize, char *title)
{
	static unsigned char closebtn[14 * 15] = {
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07
	};

	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , xsize-2, 0      );	// 㔖DF
	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , 0,       ysize-2);	// DF
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , xsize-2, 1      );	// 㔒F
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , 1,       ysize-2);	// F
	boxfill8(buf, xsize, COL8_C6C6C6, 2      , 2      , xsize-3, ysize-3);	// DFiEBhE{́j
	boxfill8(buf, xsize, COL8_0080FF, 3      , 3      , xsize-4, 20     );	// Fi^Cgo[j
	boxfill8(buf, xsize, COL8_848484, xsize-2, 1      , xsize-2, ysize-2);	// EZDF
	boxfill8(buf, xsize, COL8_848484, 1      , ysize-2, xsize-2, ysize-2);	// ZDF
	boxfill8(buf, xsize, COL8_000000, xsize-1, 0      , xsize-1, ysize-1);	// EF
	boxfill8(buf, xsize, COL8_000000, 0      , ysize-1, xsize-1, ysize-1);	// F
	putfonts8_asc(buf, xsize, 8, 4, COL8_FFFFFF, osakkielogo);
	putfonts8_asc(buf, xsize, 24, 4, COL8_FFFFFF, title);

	/* Only OSAkkie function! */
	picdata8(buf, xsize, closebtn, 15, 14, COL8_0080FF, xsize - 20, 5);

	return;
}

void make_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c)
{
	int x1 = x0 + sx, y1 = y0 + sy;

	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, c,           x0 - 1, y0 - 1, x1 + 0, y1 + 0);

	return;
}

void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l)
{
	boxfill8(sht->buf, sht->bxsize, b, x, y, x + l * 8 - 1, y + 15);
	putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
	sheet_refresh(sht, x, y, x + l * 8, y + 16);
}
