/* timerƂ */

#include "bootpack.h"

#define PIT_CTRL	0x0043
#define PIT_CNT0	0x0040

struct TIMERCTL timerctl;

#define TIMER_FLAGS_ALLOC	1	/* mۂ */
#define TIMER_FLAGS_USING	2	/* ^C}쓮 */

void init_pit(void)
{
	int i;
	io_out8(PIT_CTRL, 0x34);
	io_out8(PIT_CNT0, 0x9c);
	io_out8(PIT_CNT0, 0x2e);
	timerctl.count = 0;
	timerctl.next = 0xffffffff; /* ŏ͓쒆̃^C}Ȃ */
	timerctl.using = 0;
	for (i = 0; i < MAX_TIMER; i++)
		timerctl.timers0[i].flags = 0;	/* gp */
	return;
}

struct TIMER *timer_alloc(void)
{
	int i;
	for(i = 0; i < MAX_TIMER; i++) {
		if (timerctl.timers0[i].flags == 0) {
			timerctl.timers0[i].flags = TIMER_FLAGS_ALLOC;	/* gp */
			return &timerctl.timers0[i];
		}
	}
	return 0;	/* Ȃ */
}

void timer_free(struct TIMER *timer)
{
	timer->flags = 0;	/* gp */
	return;
}

void timer_init(struct TIMER *timer, struct FIFO8 *fifo, unsigned char data)
{
	timer->fifo = fifo;
	timer->data = data;
	return;
}

void timer_settime(struct TIMER *timer, unsigned int timeout)
{
	int e, i, j;
	timer->timeout = timeout + timerctl.count;
	timer->flags = TIMER_FLAGS_USING;	/* gp */
	e = io_load_eflags();
	io_cli();
	for (i = 0; i < timerctl.using; i++) {
		if (timerctl.timers[i]->timeout >= timer->timeout)
			break;
	}
	timerctl.using++;
	for (j = timerctl.using; j > i; j--)
		timerctl.timers[j] = timerctl.timers[j - 1];	/* ɂ炷 */

	timerctl.timers[i] = timer;
	timerctl.next = timerctl.timers[0]->timeout;	/* ̎XV */
	io_store_eflags(e);
	return;
}

void inthandler20(int *esp)
{
	int i, j;
	io_out8(PIC0_OCW2, 0x60);	/* IRQ-00tPICɒʒm */
	timerctl.count++;
	if (timerctl.next > timerctl.count)
		return;

	for (i = 0; i < timerctl.using; i++) {
		if (timerctl.timers[i]->timeout > timerctl.count)
			break;	/* ^C}쒆Ȃ̂flags`FbNȂ */
		/* ^CAEg */
		timerctl.timers[i]->flags = TIMER_FLAGS_ALLOC;
		fifo8_put(timerctl.timers[i]->fifo, timerctl.timers[i]->data);
	}

	/* i̃^C}^CAEĝŎc炷 */
	timerctl.using -= i;
	for (j = 0; j < timerctl.using; j++)
		timerctl.timers[j] = timerctl.timers[i + j];
	if (timerctl.using > 0) {
		timerctl.next = timerctl.timers[0]->timeout;
	} else {
		timerctl.next = 0xffffffff;
	}
	return;
}
