/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

static unsigned char osakkielogo[3] = {0x80, 0x81, '\0'};
void make_window8(unsigned char *buf, int xsize, int ysize, char *title);

void HariMain(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct FIFO8 timerfifo, timerfifo2, timerfifo3;
	char s[40], keybuf[32], mousebuf[128], timerbuf[8], timerbuf2[8], timerbuf3[8];
	struct TIMER *timer, *timer2, *timer3;
	int mx, my, i;
	unsigned int memtotal;
	struct MOUSE_DEC mdec;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHTCTL *shtctl;
	struct SHEET *sht_back, *sht_mouse, *sht_win;
	unsigned char *buf_back, buf_mouse[256], *buf_win;

/*
	static char font_mini_A[12] = {
		0x00, 0x30, 0x30, 0x48, 0x48, 0x48,
		0x48, 0x78,	0x48, 0x48, 0x48, 0x00
	};
*/

	init_gdtidt();
	init_pic();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	fifo8_init(&keyfifo, 32, keybuf);
	fifo8_init(&mousefifo, 128, mousebuf);
	init_pit();
	io_out8(PIC0_IMR, 0xf8); /* PITPIC1ƃL[{[h(11111000) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */

	fifo8_init(&timerfifo, 8, timerbuf);
	timer = timer_alloc();
	timer_init(timer, &timerfifo, 1);
	timer_settime(timer, 1000);
	fifo8_init(&timerfifo2, 8, timerbuf2);
	timer2 = timer_alloc();
	timer_init(timer2, &timerfifo2, 1);
	timer_settime(timer2, 300);
	fifo8_init(&timerfifo3, 8, timerbuf3);
	timer3 = timer_alloc();
	timer_init(timer3, &timerfifo3, 1);
	timer_settime(timer3, 50);

	init_keyboard();
	enable_mouse(&mdec);
	memtotal = memtest(0x00400000,0xbfffffff);
	memman_init(memman);
	memman_free(memman, 0x00001000, 0x0009e000); /*	0x00001000 - 0x0009efff */
	memman_free(memman, 0x00400000, memtotal - 0x00400000);

	init_palette();
	shtctl = shtctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	sht_back  = sheet_alloc(shtctl);
	sht_mouse = sheet_alloc(shtctl);
	sht_win   = sheet_alloc(shtctl);
	buf_back  = (unsigned char *) memman_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	buf_win   = (unsigned char *) memman_alloc_4k(memman, 160 * 52);
	sheet_setbuf(sht_back,  buf_back,  binfo->scrnx, binfo->scrny, -1);	/* FȂ */
	sheet_setbuf(sht_mouse, buf_mouse, 16,  16, 99);	/* Fԍ99 */
	sheet_setbuf(sht_win,   buf_win,   160, 52, -1);	/* FȂ */
	init_screen8(buf_back, binfo->scrnx, binfo->scrny);
	init_mouse_cursor8(buf_mouse, 99/* wiF */);
	make_window8(buf_win, 160, 52, "!!");
	sheet_slide(sht_back, 0, 0);
	mx = (binfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (binfo->scrny - 16) / 2;
	sheet_slide(sht_mouse, mx, my);
	sheet_slide(sht_win, 80, 72);
	sheet_updown(sht_back,  0);
	sheet_updown(sht_win, 1);
	sheet_updown(sht_mouse, 2);
	sprintf(s, "(%3d, %3d)", mx, my);
	putfonts8_asc(buf_back, binfo->scrnx, 0, 0, COL8_FFFFFF, s);
	sprintf(s, "Memory: %dKB   Free: %dKB", memtotal / 1000, memman_total(memman) / 1024);
	putfonts8_asc(buf_back, binfo->scrnx, 0, 32, COL8_FFFFFF, s);
	sheet_refresh(sht_back, 0, 0, binfo->scrnx, 48);

	for (;;) {
		sprintf(s, "%010d", timerctl.count);
		boxfill8(buf_win, 160, COL8_C6C6C6, 40, 28, 119, 43);
		putfonts8_asc(buf_win, 160, 40, 28, COL8_000000, s);
		sheet_refresh(sht_win, 40, 28, 120, 44);

		io_cli();
		if (fifo8_status(&keyfifo) + fifo8_status(&mousefifo) + fifo8_status(&timerfifo)
				+ fifo8_status(&timerfifo2) + fifo8_status(&timerfifo3) == 0) {
//			io_stihlt();
			io_sti();
		} else {
			if (fifo8_status(&keyfifo) != 0) {
				i = fifo8_get(&keyfifo);
				io_sti();
				sprintf(s, "%02X", i);
				boxfill8(buf_back, binfo->scrnx, COL8_3A6EA5, 0, 16, 15, 31);
				putfonts8_asc(buf_back, binfo->scrnx, 0, 16, COL8_FFFFFF, s);
				sheet_refresh(sht_back, 0, 16, 16, 32);
			} else if (fifo8_status(&mousefifo) != 0) {
				i = fifo8_get(&mousefifo);
				io_sti();
				if (mouse_decode(&mdec, i)) {
					sprintf(s, "[lcr %4d %4d]", mdec.x, mdec.y);
					if (mdec.btn & 0x01)
						s[1] = 'L';
					if (mdec.btn & 0x02)
						s[3] = 'R';
					if (mdec.btn & 0x04)
						s[2] = 'C';
					boxfill8(buf_back, binfo->scrnx, COL8_3A6EA5, 32, 16, 32 + 15 * 8 - 1, 31);
					putfonts8_asc(buf_back, binfo->scrnx, 32, 16, COL8_FFFFFF, s);
					sheet_refresh(sht_back, 32, 16, 32 + 15 * 8, 32);
					/* }EXړ */
					mx += mdec.x;
					my += mdec.y;
					if (mx < 0)
						mx = 0;
					if (my < 0)
						my = 0;
					if (mx > binfo->scrnx - 1)
						mx = binfo->scrnx - 1;
					if (my > binfo->scrny - 1)
						my = binfo->scrny - 1;
					sprintf(s, "(%3d, %3d)", mx, my);
					boxfill8(buf_back, binfo->scrnx, COL8_3A6EA5, 0, 0, 79, 15);
					putfonts8_asc(buf_back, binfo->scrnx, 0, 0, COL8_FFFFFF, s);
					sheet_refresh(sht_back, 0, 0, 80, 16);
					sheet_slide(sht_mouse, mx, my);
				}
			} else if (fifo8_status(&timerfifo) != 0) {
				i = fifo8_get(&timerfifo);
				io_sti();
				putfonts8_asc(buf_back, binfo->scrnx, 0, 64, COL8_FFFFFF, ".:10sec:.");
				sheet_refresh(sht_back, 0, 64, 72, 80);
			} else if (fifo8_status(&timerfifo2) != 0) {
				i = fifo8_get(&timerfifo2);
				io_sti();
				putfonts8_asc(buf_back, binfo->scrnx, 0, 80, COL8_FFFFFF, ".:3sec:.");
				sheet_refresh(sht_back, 0, 80, 64, 96);
			} else if (fifo8_status(&timerfifo3) != 0) {
				i = fifo8_get(&timerfifo3);
				io_sti();
				if (i != 0) {
					timer_init(timer3, &timerfifo3, 0);	/* 0 */
					boxfill8(buf_back, binfo->scrnx, COL8_FFFFFF, 8, 96, 15, 111);
				} else {
					timer_init(timer3, &timerfifo3, 1);	/* 1 */
					boxfill8(buf_back, binfo->scrnx, COL8_3A6EA5, 8, 96, 15, 111);
				}
				timer_settime(timer3, 50);
				sheet_refresh(sht_back, 8, 96, 16, 112);
			}
		}
	}
}

void make_window8(unsigned char *buf, int xsize, int ysize, char *title)
{
	static unsigned char closebtn[14 * 15] = {
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07
	};

	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , xsize-2, 0      );	// 㔖DF
	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , 0,       ysize-2);	// DF
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , xsize-2, 1      );	// 㔒F
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , 1,       ysize-2);	// F
	boxfill8(buf, xsize, COL8_C6C6C6, 2      , 2      , xsize-3, ysize-3);	// DFiEBhE{́j
	boxfill8(buf, xsize, COL8_0080FF, 3      , 3      , xsize-4, 20     );	// Fi^Cgo[j
	boxfill8(buf, xsize, COL8_848484, xsize-2, 1      , xsize-2, ysize-2);	// EZDF
	boxfill8(buf, xsize, COL8_848484, 1      , ysize-2, xsize-2, ysize-2);	// ZDF
	boxfill8(buf, xsize, COL8_000000, xsize-1, 0      , xsize-1, ysize-1);	// EF
	boxfill8(buf, xsize, COL8_000000, 0      , ysize-1, xsize-1, ysize-1);	// F
	putfonts8_asc(buf, xsize, 8, 4, COL8_FFFFFF, osakkielogo);
	putfonts8_asc(buf, xsize, 24, 4, COL8_FFFFFF, title);

	/* Only OSAkkie function! */
	picdata8(buf, xsize, closebtn, 15, 14, COL8_0080FF, xsize - 20, 5);

	return;
}
