/* FIFOCu */

#include "bootpack.h"

#define FLAGS_OVERRUN		0x0001

void fifo8_init(struct FIFO8 *fifo, int size, unsigned char *buf)
/* FIFOobt@̏ */
{
	fifo->size = size;
	fifo->buf = buf;
	fifo->free = size; /*  */
	fifo->flags = 0;
	fifo->p = 0; /* ݈ʒu */
	fifo->q = 0; /* ǂݍ݈ʒu */
	return;
}

int fifo8_put(struct FIFO8 *fifo, unsigned char data)
/* FIFOփf[^𑗂荞Œ~ */
{
	if (fifo->free == 0) {
		/* 󂫂ȂĂӂꂽ */
		fifo->flags |= FLAGS_OVERRUN;
		return -1;
	}
	fifo->buf[fifo->p] = data;
	fifo->p++;
	if (fifo->p == fifo->size) {
		fifo->p = 0;
	}
	fifo->free--;
	return 0;
}

int fifo8_get(struct FIFO8 *fifo)
/* FIFOf[^ƂĂ */
{
	int data;
	if (fifo->free == fifo->size) {
		/* obt@ۂ̂Ƃ́AƂ肠-1Ԃ */
		return -1;
	}
	data = fifo->buf[fifo->q];
	fifo->q++;
	if (fifo->q == fifo->size) {
		fifo->q = 0;
	}
	fifo->free++;
	return data;
}

int fifo8_status(struct FIFO8 *fifo)
/* ǂ̂炢f[^܂Ă邩񍐂 */
{
	return fifo->size - fifo->free;
}
