/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

#define MEMMAN_FREES 	4090 		/* 32KB */
#define MEMMAN_ADDR		0x003c0000	/* MEMMANuAhX */

struct FREEINFO { /* 󂫏 */
	unsigned int addr,size;
};

struct MEMMAN {	/* Ǘ */
	int frees, maxfrees, lostsize, losts;
	struct FREEINFO free[MEMMAN_FREES];
};

unsigned int memtest(unsigned int start, unsigned int end);
void memman_init(struct MEMMAN *man);
unsigned int memman_total(struct MEMMAN *man);
unsigned int memman_alloc(struct MEMMAN *man, unsigned int size);
int memman_free(struct MEMMAN *man, unsigned int addr, unsigned int size);

void HariMain(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) 0x0ff0;
	struct MOUSE_DEC mdec;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	char s[40], mcursor[256], keybuf[32], mousebuf[128];
	int mx, my, i;
	unsigned int memtotal;
/*
	static char font_mini_A[12] = {
		0x00, 0x30, 0x30, 0x48, 0x48, 0x48,
		0x48, 0x78,	0x48, 0x48, 0x48, 0x00
	};
*/

	init_gdtidt();
	init_pic();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	fifo8_init(&keyfifo, 32, keybuf);
	fifo8_init(&mousefifo, 128, mousebuf);
	io_out8(PIC0_IMR, 0xf9); /* PIC1ƃL[{[h(11111001) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */

	init_keyboard();
	enable_mouse(&mdec);

	init_palette();
	init_screen8(binfo->vram, binfo->scrnx, binfo->scrny);
	putfonts8_asc(binfo->vram, binfo->scrnx,  8*11,  0, COL8_FFFFFF, "OSAkkie");

	mx = (binfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (binfo->scrny - 16) / 2;
	init_mouse_cursor8(mcursor, 16/* wiF */);
	putblock8_8(binfo->vram, binfo->scrnx, 16, 16, mx, my, mcursor, 16);
	sprintf(s, "(%3d, %3d)", mx, my);
	putfonts8_asc(binfo->vram, binfo->scrnx, 0, 0, COL8_FFFFFF, s);


	memtotal = memtest(0x00400000,0xbfffffff);
	memman_init(memman);
	memman_free(memman, 0x00001000, 0x0009e000); /*	0x00001000 - 0x0009efff */
	memman_free(memman, 0x00400000, memtotal - 0x00400000);
	sprintf(s, "Memory: %dKB   Free: %dKB", memtotal / 1000, memman_total(memman) / 1024);
	putfonts8_asc(binfo->vram, binfo->scrnx, 0, 32, COL8_FFFFFF, s);

	for (;;) {
		io_cli();
		if (fifo8_status(&keyfifo) + fifo8_status(&mousefifo) == 0) {
			io_stihlt();
		} else {
			if (fifo8_status(&keyfifo) != 0) {
				i = fifo8_get(&keyfifo);
				io_sti();
				sprintf(s, "%02X", i);
				boxfill8(binfo->vram, binfo->scrnx, COL8_3A6EA5, 0, 16, 15, 31);
				putfonts8_asc(binfo->vram, binfo->scrnx, 0, 16, COL8_FFFFFF, s);
			} else if (fifo8_status(&mousefifo) != 0) {
				i = fifo8_get(&mousefifo);
				io_sti();
				if (mouse_decode(&mdec, i)) {
					sprintf(s, "[lcr %4d %4d]", mdec.x, mdec.y);
					if (mdec.btn & 0x01)
						s[1] = 'L';
					if (mdec.btn & 0x02)
						s[3] = 'R';
					if (mdec.btn & 0x04)
						s[2] = 'C';
					boxfill8(binfo->vram, binfo->scrnx, COL8_3A6EA5, 32, 16, 32 + 15 * 8 - 1, 31);
					putfonts8_asc(binfo->vram, binfo->scrnx, 32, 16, COL8_FFFFFF, s);
					/* }EXړ */
					boxfill8(binfo->vram, binfo->scrnx, COL8_3A6EA5, mx, my, mx + 15, my + 15);
					mx += mdec.x;
					my += mdec.y;
					if (mx < 0)
						mx = 0;
					if (my < 0)
						my = 0;
					if (mx > binfo->scrnx - 16)
						mx = binfo->scrnx - 16;
					if (my > binfo->scrny - 16)
						my = binfo->scrny - 16;
					sprintf(s, "(%3d, %3d)", mx, my);
					boxfill8(binfo->vram, binfo->scrnx, COL8_3A6EA5, 0, 0, 79, 15);
					putfonts8_asc(binfo->vram, binfo->scrnx, 0, 0, COL8_FFFFFF, s);
					putblock8_8(binfo->vram, binfo->scrnx, 16, 16, mx, my, mcursor, 16);
				}
			}
		}
	}
}

#define EFLAGS_AC_BIT		0x00040000
#define CR0_CACHE_DISABLE	0x60000000

unsigned int memtest(unsigned int start, unsigned int end)
{
	char flg486 = 0;
	unsigned int eflg, cr0, i;

	/* 386A486ȍ~mF */
	eflg = io_load_eflags() | EFLAGS_AC_BIT;
	io_store_eflags(eflg);
	eflg = io_load_eflags() & EFLAGS_AC_BIT;
	if (eflg)
		flg486 = 1;
	eflg &= ~EFLAGS_AC_BIT;		// and̂
	io_store_eflags(eflg);

	if (flg486) {
		cr0 = load_cr0() | CR0_CACHE_DISABLE;	/* LbV֎~ */
		store_cr0(cr0);
	}

	i = memtest_sub(start, end);

	if (flg486) {
		cr0 = load_cr0();
		cr0 &= ~CR0_CACHE_DISABLE;	/* LbV */
		store_cr0(cr0);
	}

	return i;
}

void memman_init(struct MEMMAN *man)
{
	man->frees = 0;		/* 󂫏̌ */
	man->maxfrees = 0;	/* 󋵊ώ@p: frees̍ől */
	man->lostsize = 0;	/* JɎsvTCY */
	man->losts = 0;		/* JɎs */
	return;
}

unsigned int memman_total(struct MEMMAN *man)
/* 󂫃TCY̍v */
{
	unsigned int i, t = 0;
	for (i = 0; i < man->frees; i++)
		t += man->free[i].size;
	return t;
}

unsigned int memman_alloc(struct MEMMAN *man, unsigned int size)
/* m */
{
	unsigned int i, a;
	for (i = 0; i < man->frees; i++) {
		if (man->free[i].size >= size) {
			/* \ȍL̋󂫂𔭌 */
			a = man->free[i].addr;
			man->free[i].addr += size;
			man->free[i].size -= size;
			if (man->free[i].size == 0) {
				/* free[i]ȂȂ̂őOɋl߂ */
				man->frees--;
				for (; i < man->frees; i++)
					man->free[i] = man->free[i + 1];
			}
			return a;
		}
	}
	return 0;	/* 󂫂Ȃ */
}

int memman_free(struct MEMMAN *man, unsigned int addr, unsigned int size)
/*  */
{
	int i, j;

	/* free[]addrɕׂ邽߂ɁAǂɓ邩߂ */
	for (i = 0; i < man->frees; i++) {
		if (man->free[i].addr > addr)
			break;
	}
	/* free[i - 1].addr < addr < free[i].addr */
	if (0 < i) {
		/* p^[1-1: ꏊO */
		if (man->free[i - 1].addr + man->free[i - 1].size == addr) {
			/* ̑Ő󂫗̈ɂ܂Ƃ߂ */
			man->free[i - 1].size += size;
			if (i < man->frees) {
				/* p^[1-2: ꂽꏊ */
				if (addr + size == man->free[i].addr) {
					/* ̗̈܂Ƃ߂ */
					man->free[i - 1].size += man->free[i].size;
					/* man->free[i]̍폜:: Oɋl߂ */
					man->frees--;
					for (; i < man->frees; i++)
						man->free[i] = man->free[i + 1];
				}
			}
			return 0;	/* E}[ */
		}
	}
	if (i < man->frees) {
		/* p^[2: ꏊ낪 */
		if (addr + size == man->free[i].addr) {
			/* ̗̈ɂ܂Ƃ߂ */
			man->free[i].addr = addr;
			man->free[i].size += size;
			return 0;	/* E}[ */
		}
	}
	if (man->frees < MEMMAN_FREES) {
		/* p^[3: OƂ܂Ƃ߂ꏊȂ̂ŐVɃXL} */
		/* free[i]Ԗڂɂ1ɂĂ炤 */
		for (j = man->frees; j < i; j--)
			man->free[j] = man->free[j - 1];
		man->frees++;
		if (man->maxfrees < man->frees)
			man->maxfrees = man->frees;	/* őlXV */
			man->free[i].addr = addr;
			man->free[i].size = size;
			return 0;	/* E}[ */
	}
	/* p^[4:ǂɂłȂ̂ŁuȂǎ̂ĂĂ܂v */
	man->losts++;
	man->lostsize += size;
	return -1;
}
