/* $Id: self.c,v 1.3 2003/02/24 09:23:08 tkubo Exp $ */

/* self.c - high-level API of hardmeter
 *
 * Copyright (C) 2003 Hardmeter Project <http://hardmeter.sourceforge.jp>
 *
 * This project is supported by IPA(Information-technology Promotion
 * Agency, Japan).
 *
 * "hardmeter" is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hardmeter.h"

static hardmeter_t *hardmeter_handle = NULL;
static char *dumpfilename = NULL;

int hardmeter_start(const char *name)
{
	hardmeter_option_t opt;
	char *filename = NULL;
	const char *err = NULL;
	FILE *fp = NULL;

	if (dumpfilename != NULL) {
		free(dumpfilename);
		dumpfilename = NULL;
	}
	if (hardmeter_handle != NULL) {
		hardmeter_close(hardmeter_handle, NULL);
		hardmeter_handle = NULL;
	}

	memset(&opt, 0, sizeof(opt));
	opt.eventmask = -1;
	hardmeter_init(NULL);
	if (hardmeter_parse_rc(&opt, &filename, name, &err) != 0) {
		/* err is set by hardmeter_parse_rc(). */
		goto error_report;
	}
	if (filename == NULL) {
		err = "dumpfile was not specified.";
		goto error_report;
	}
	if (opt.template == NULL) {
		err = "event was not specified or not found specified name.";
		goto error_report;
	}
	hardmeter_handle = hardmeter_open(&opt, &err);
	if (hardmeter_handle == NULL) {
		/* err is set by hardmeter_open(). */
		goto error_report;
	}
	dumpfilename = strdup(filename);
	return 0;
error_report:
	if (filename != NULL) {
		fp = fopen(filename, "w");
	}
	if (fp == NULL) {
		fp = fopen("/tmp/hardmeter.log", "a");
	}
	if (fp == NULL) {
		return -1;
	}
	fprintf(fp, "ERROR: %s\n", err);
	fclose(fp);
	return -1;
}

int hardmeter_stop(void)
{
	if (hardmeter_handle && dumpfilename) {
		hardmeter_dump(hardmeter_handle, dumpfilename, 1, NULL);
	}
	if (dumpfilename != NULL) {
		free(dumpfilename);
		dumpfilename = NULL;
	}
	if (hardmeter_handle != NULL) {
		hardmeter_close(hardmeter_handle, NULL);
		hardmeter_handle = NULL;
	}
	return 0;
}
