//  catable.hpp: operator +/* for Souces

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef HAMIGAKI_IOSTREAMS_CATABLE_HPP
#define HAMIGAKI_IOSTREAMS_CATABLE_HPP

#include <boost/iostreams/detail/template_params.hpp>

#define HAMIGAKI_IOSTREAMS_CATABLE(source, arity) \
    namespace hamigaki{namespace iostreams{namespace cat_operators{ \
        template< BOOST_PP_ENUM_PARAMS(arity, typename T) \
                  BOOST_PP_COMMA_IF(arity) typename Component> \
        ::hamigaki::iostreams::concatenation< \
            source BOOST_IOSTREAMS_TEMPLATE_ARGS(arity, T), \
            Component \
        > operator+( const source BOOST_IOSTREAMS_TEMPLATE_ARGS(arity, T)& s, \
                     const Component& c ) \
        { \
            return ::hamigaki::iostreams::concatenation< \
                       source BOOST_IOSTREAMS_TEMPLATE_ARGS(arity, T), \
                       Component> \
                       (s, c); \
        }; \
        template< BOOST_PP_ENUM_PARAMS(arity, typename T) \
                  BOOST_PP_COMMA_IF(arity) typename Component > \
        ::hamigaki::iostreams::loop_source< \
            source BOOST_IOSTREAMS_TEMPLATE_ARGS(arity, T) \
        > operator*( const source BOOST_IOSTREAMS_TEMPLATE_ARGS(arity, T)& s, \
                     Component count ) \
        { \
            return ::hamigaki::iostreams::loop_source< \
                       source BOOST_IOSTREAMS_TEMPLATE_ARGS(arity, T) > \
                       (s, count); \
        }; \
    }}} \
    /**/

namespace hamigaki { namespace iostreams {

template<class Source1, class Source2>
class concatenation;

template<class Source>
class loop_source;

} } // End namespaces iostreams, hamigaki.

#endif // HAMIGAKI_IOSTREAMS_CATABLE_HPP
