//  pcm_device.hpp: a simple pcm device

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef HAMIGAKI_AUDIO_PCM_DEVICE_HPP
#define HAMIGAKI_AUDIO_PCM_DEVICE_HPP

#include <hamigaki/audio/pcm/format.hpp>
#include <boost/iostreams/categories.hpp>
#include <boost/shared_ptr.hpp>

#if defined(BOOST_WINDOWS)
#pragma comment(lib, "winmm.lib")
#endif

namespace hamigaki { namespace audio {

class pcm_sink
{
public:
    typedef char char_type;

    struct category :
        boost::iostreams::sink_tag,
        boost::iostreams::closable_tag,
        boost::iostreams::flushable_tag {};

    pcm_sink(const pcm_format& f, std::size_t buffer_size);

    std::streamsize write(const char* s, std::streamsize n);
    bool flush();
    void close();

private:
    class impl;
    boost::shared_ptr<impl> pimpl_;
};

} } // End namespaces audio, hamigaki.

#endif // HAMIGAKI_AUDIO_PCM_DEVICE_HPP
