package farm.example;

import static org.junit.Assert.*;

import org.junit.Test;

/**
 * 
 * @author yupong7@gmail.com
 */
public class CatTest {

	@Test
	public void testCopyObject() throws CloneNotSupportedException {
		Cat orig = new Cat();
		orig.setName("タマ");
		Cat copy = (Cat)orig.clone();

		// 同オブジェクトではない
		assertEquals(false, orig == copy);

		// 同じ値である
		assertEquals(true,  orig.equals(copy));
	}
	
	@Test
	public void testSameObject() throws CloneNotSupportedException {
		Cat orig = new Cat();
		orig.setName("マイケル");
		Cat same = orig;

		// 同じオブジェクトである
		assertEquals(true,  orig == same);

		// 同じ値である
		assertEquals(true,  orig.equals(same));
	}
	
	@Test
	public void testSameObject2() throws CloneNotSupportedException {
		Cat orig = new Cat();
		orig.setName("Tom");

		// 同じオブジェクトである
		assertEquals(true,  (Cat)orig == (Cat)orig);

		// 同じ値である
		assertEquals(true,  orig.equals(orig));
	}
}
