package farm.example.ifrog;

import java.io.Serializable;

/**
 * 
 * @author mimoto
 * @author yupong7@gmail.com
 */
public class Station implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3862380576258595761L;

	/** 沿線コード */
	private Long lineCd;

	/** 駅名 */
	private String name = "";

	public final Long getLineCd() {
		return lineCd;
	}


	public final void setLineCd(Long lineCd) {
		this.lineCd = lineCd;
	}


	public final String getName() {
		return name;
	}


	public final void setName(String name) {
		this.name = name;
	}

	
	@Override
	public String toString() {
		return "Station: Name,LineCd=(" + getName() + "," + getLineCd() + ")";
	}

	@Override
	public boolean equals(Object obj) {
		boolean ret = false;
		
		if(obj instanceof Station) {
			Station station = (Station)obj;
			
			boolean ret1 = getName().equals(station.getName());
			boolean ret2 = getLineCd().equals(station.getLineCd());
			ret = ret1 && ret2;
		}
		
		return ret;
	}

	@Override
	public Station clone() throws CloneNotSupportedException {
		Station ret = new Station();
		ret.setLineCd(getLineCd());
		ret.setName(getName());
		return ret;
	}
}
