package farm.example;

import java.util.HashMap;
import java.util.Map;

public class AuthPool {
	private static AuthPool instance = new AuthPool();
	
	private Map<String, Auth> pool;
	
	private AuthPool() {
		pool = new HashMap<String, Auth>();
	}
	
	public static AuthPool getInstance() {
		return instance;
	}

	public Auth getAuth(String id) {
		Auth ret = pool.get(id);
		if(ret == null) {
			ret = new Auth(id);
			pool.put(id, ret);
		}
		return ret;
	}
}
