/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public abstract class RangeSet<C extends Comparable>
implements Predicate<C> {
    private transient RangeSet<C> complement;

    RangeSet() {
    }

    public boolean contains(C value) {
        return this.rangeContaining(value) != null;
    }

    public abstract Range<C> rangeContaining(C var1);

    public abstract Range<C> rangeBelow(C var1);

    public abstract Range<C> rangeAbove(C var1);

    public abstract Range<C> firstRange();

    public abstract Range<C> lastRange();

    public final RangeSet<C> complement() {
        RangeSet<C> result = this.complement;
        if (result == null) {
            result = this.createComplement();
            result.complement = this;
            this.complement = result;
        }
        return this.complement;
    }

    abstract RangeSet<C> createComplement();

    public void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    public void remove(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    public abstract Set<Range<C>> ranges();

    public abstract Range<C> span();

    public abstract boolean encloses(Range<C> var1);

    public boolean enclosesAll(RangeSet<C> other) {
        for (Range<C> range : other.ranges()) {
            if (this.encloses(range)) continue;
            return false;
        }
        return true;
    }

    public void addAll(RangeSet<C> other) {
        for (Range<C> range : other.ranges()) {
            this.add(range);
        }
    }

    public void removeAll(RangeSet<C> other) {
        for (Range<C> range : other.ranges()) {
            this.remove(range);
        }
    }

    @Override
    public final boolean apply(C input) {
        return this.contains(input);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RangeSet) {
            return ((Object)this.ranges()).equals(((RangeSet)obj).ranges());
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this.ranges()).hashCode();
    }

    public final String toString() {
        return this.ranges().toString();
    }
}

