/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.Future;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemcacheServiceApiHelper {
    static final String PACKAGE = "memcache";
    private static final Logger logger = Logger.getLogger(MemcacheServiceApiHelper.class.getName());

    private MemcacheServiceApiHelper() {
    }

    static <M extends Message, T> Future<T> makeAsyncCall(String methodName, Message request, final RpcResponseHandler<M, T> responseHandler, final Provider<T> defaultValue) {
        Future<byte[]> asyncResp = ApiProxy.makeAsyncCall(PACKAGE, methodName, request.toByteArray());
        return new FutureWrapper<byte[], T>(asyncResp){

            @Override
            protected T wrap(byte[] bytes) throws Exception {
                return bytes == null ? null : (Object)responseHandler.convertResponse(bytes);
            }

            @Override
            protected T absorbParentException(Throwable cause) throws Throwable {
                responseHandler.handleApiProxyException(cause);
                return defaultValue.get();
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RpcResponseHandler<M extends Message, T> {
        private final String errorText;
        private final Message.Builder builder;
        private final Transformer<M, T> responseTransfomer;
        private final ErrorHandler errorHandler;

        RpcResponseHandler(M response, String errorText, Transformer<M, T> responseTransfomer, ErrorHandler errorHandler) {
            this.builder = response.newBuilderForType();
            this.errorText = errorText;
            this.responseTransfomer = responseTransfomer;
            this.errorHandler = errorHandler;
        }

        T convertResponse(byte[] responseBytes) throws InvalidProtocolBufferException {
            Message response = this.builder.mergeFrom(responseBytes).build();
            return this.responseTransfomer.transform(response);
        }

        void handleApiProxyException(Throwable cause) throws Throwable {
            try {
                throw cause;
            }
            catch (InvalidProtocolBufferException ex) {
                this.errorHandler.handleServiceError(new MemcacheServiceException("Could not decode response:", ex));
            }
            catch (ApiProxy.ApplicationException ex) {
                logger.info(this.errorText + ": " + ex.getErrorDetail());
                this.errorHandler.handleServiceError(new MemcacheServiceException(this.errorText));
            }
            catch (ApiProxy.ApiProxyException ex) {
                this.errorHandler.handleServiceError(new MemcacheServiceException(this.errorText, ex));
            }
        }

        Logger getLogger() {
            return logger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Transformer<F, T> {
        public T transform(F var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Provider<T> {
        public T get();
    }
}

