/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheServiceException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogAndContinueErrorHandler
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(LogAndContinueErrorHandler.class.getName());
    private final Level level;

    public LogAndContinueErrorHandler(Level level) {
        this.level = level;
    }

    public void handleDeserializationError(InvalidValueException thrown) {
        logger.log(this.level, "Deserialization error in memcache", thrown);
    }

    public void handleServiceError(MemcacheServiceException thrown) {
        logger.log(this.level, "Service error in memcache", thrown);
    }
}

