/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.memcache.BaseMemcacheService;
import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.ErrorHandlers;

abstract class BaseMemcacheServiceImpl
implements BaseMemcacheService {
    private volatile ErrorHandler handler = ErrorHandlers.getDefault();
    private String namespace;

    BaseMemcacheServiceImpl(String namespace) {
        if (namespace != null) {
            NamespaceManager.validateNamespace(namespace);
        }
        this.namespace = namespace;
    }

    public ErrorHandler getErrorHandler() {
        return this.handler;
    }

    public void setErrorHandler(ErrorHandler newHandler) {
        if (newHandler == null) {
            throw new NullPointerException("ErrorHandler must not be null");
        }
        this.handler = newHandler;
    }

    public String getNamespace() {
        return this.namespace;
    }

    void setNamespace(String newNamespace) {
        this.namespace = newNamespace;
    }

    protected String getEffectiveNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        String namespace1 = NamespaceManager.get();
        return namespace1 == null ? "" : namespace1;
    }
}

