/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.storage.onestore.v3.OnestoreEntity;

public class EntityTranslator {
    public static Entity createFromPb(OnestoreEntity.EntityProto proto) {
        Key key = KeyTranslator.createFromPb(proto.getKey());
        Entity entity = new Entity(key);
        entity.setEntityProto(proto);
        DataTypeTranslator.extractPropertiesFromPb(proto, entity.getPropertyMap());
        return entity;
    }

    public static Entity createFromPbBytes(byte[] pbBytes) {
        OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
        proto.mergeFrom(pbBytes);
        return EntityTranslator.createFromPb(proto);
    }

    public static OnestoreEntity.EntityProto convertToPb(Entity entity) {
        OnestoreEntity.Reference reference = KeyTranslator.convertToPb(entity.getKey());
        OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
        proto.getMutableKey().mergeFrom(reference);
        OnestoreEntity.Path entityGroup = proto.getMutableEntityGroup();
        Key key = entity.getKey();
        if (key.isComplete()) {
            entityGroup.addElement(reference.getPath().elements().get(0));
        }
        DataTypeTranslator.addPropertiesToPb(entity.getPropertyMap(), proto);
        return proto;
    }

    private EntityTranslator() {
    }
}

