/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class BasicIo {
    public static final String[] FACTOR_ABVS = new String[]{"", "KB", "MB", "GB", "TB", "BB"};

    public static int s2n(byte[] buf, int offset, int length, boolean signed, boolean intel) {
        int msb;
        int val = 0;
        if (intel) {
            int shift = 0;
            for (int i = offset; i < length + offset && i < buf.length; ++i) {
                val += (buf[i] & 0xFF) << shift;
                shift += 8;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                val = (val << 8) + (buf[offset + i] & 0xFF);
            }
        }
        if (signed && (val & (msb = 1 << 8 * length - 1)) > 0) {
            val -= msb << 1;
        }
        return val;
    }

    public static void in2s(byte[] result, int offset, int value, int length) {
        for (int i = 0; i < length; ++i) {
            result[offset + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    public static void bn2s(byte[] result, int offset, int value, int length) {
        for (int i = 0; i < length; ++i) {
            result[offset + length - i - 1] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    public static byte[] bn2s(int value, int length) {
        byte[] result = new byte[length];
        BasicIo.bn2s(result, 0, value, length);
        return result;
    }

    public static boolean isSignature(byte[] markerData, int offset, String signature) {
        for (int i = 0; i < signature.length(); ++i) {
            if (signature.charAt(i) == (markerData[offset + i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public static long skip(InputStream is, long n) throws IOException {
        long lefttoskip = n;
        if (n > 0L) {
            long skipLen;
            do {
                if ((skipLen = is.skip(lefttoskip)) >= 1L || is.read() == -1) continue;
                skipLen = 1L;
            } while ((lefttoskip -= skipLen) > 0L && skipLen > 0L);
        }
        return n - lefttoskip;
    }

    public static int read(InputStream is, byte[] b, int off, int minBytes, int n) throws IOException {
        if (n < 0 || minBytes > n) {
            throw new IOException("Invalid parameters minBytes = " + minBytes + " n = " + n);
        }
        int lefttoread = n;
        if (n > 0) {
            int readLen;
            int minLeft = minBytes;
            do {
                if ((readLen = is.read(b, off, lefttoread)) <= 0) continue;
                off += readLen;
                lefttoread -= readLen;
                minLeft -= readLen;
            } while (minLeft > 0 && readLen >= 0);
        }
        return n - lefttoread;
    }

    public static int read(InputStream is, byte[] data) throws IOException {
        return BasicIo.read(is, data, 0, data.length, data.length);
    }

    public static String convertLength(long l) {
        int i = 0;
        while (l >= 1024L) {
            l /= 1024L;
            ++i;
        }
        return "" + l + FACTOR_ABVS[i];
    }

    public static int asInt(String str) {
        try {
            return ((ByteBuffer)ByteBuffer.allocate(4).put(str.getBytes("ISO8859_1")).order(ByteOrder.LITTLE_ENDIAN).flip()).getInt();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Can't represent  " + str + " as int");
        }
    }

    public static String asString(int i) {
        return Charset.forName("ISO8859_1").decode((ByteBuffer)ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(i).flip()).toString();
    }
}

