/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.nio.entity;

import com.google.appengine.repackaged.org.apache.http.nio.ContentDecoder;
import com.google.appengine.repackaged.org.apache.http.nio.IOControl;
import com.google.appengine.repackaged.org.apache.http.nio.entity.ContentListener;
import com.google.appengine.repackaged.org.apache.http.nio.util.ByteBufferAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SkipContentListener
implements ContentListener {
    private final ByteBuffer buffer;

    public SkipContentListener(ByteBufferAllocator allocator) {
        if (allocator == null) {
            throw new IllegalArgumentException("ByteBuffer allocator may not be null");
        }
        this.buffer = allocator.allocate(2048);
    }

    public void contentAvailable(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        int lastRead;
        int totalRead = 0;
        do {
            this.buffer.clear();
            lastRead = decoder.read(this.buffer);
            if (lastRead <= 0) continue;
            totalRead += lastRead;
        } while (lastRead > 0);
    }

    public void finished() {
    }
}

