/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.util;

import com.google.appengine.repackaged.org.apache.commons.codec.net.URLCodec;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClientError;
import com.google.appengine.repackaged.org.apache.commons.httpclient.NameValuePair;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.io.UnsupportedEncodingException;

public class EncodingUtil {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final Log LOG = LogFactory.getLog(EncodingUtil.class);

    public static String formUrlEncode(NameValuePair[] nameValuePairArray, String string) {
        try {
            return EncodingUtil.doFormUrlEncode(nameValuePairArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Encoding not supported: " + string);
            try {
                return EncodingUtil.doFormUrlEncode(nameValuePairArray, DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                throw new HttpClientError("Encoding not supported: ISO-8859-1");
            }
        }
    }

    private static String doFormUrlEncode(NameValuePair[] nameValuePairArray, String string) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nameValuePairArray.length; ++i) {
            URLCodec uRLCodec = new URLCodec();
            NameValuePair nameValuePair = nameValuePairArray[i];
            if (nameValuePair.getName() == null) continue;
            if (i > 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append(uRLCodec.encode(nameValuePair.getName(), string));
            stringBuffer.append("=");
            if (nameValuePair.getValue() == null) continue;
            stringBuffer.append(uRLCodec.encode(nameValuePair.getValue(), string));
        }
        return stringBuffer.toString();
    }

    public static String getString(byte[] byArray, int n, int n2, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + string + ". System encoding used");
            }
            return new String(byArray, n, n2);
        }
    }

    public static String getString(byte[] byArray, String string) {
        return EncodingUtil.getString(byArray, 0, byArray.length, string);
    }

    public static byte[] getBytes(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unsupported encoding: " + string2 + ". System encoding used.");
            }
            return string.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HttpClientError("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(byArray, n, n2, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HttpClientError("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] byArray) {
        return EncodingUtil.getAsciiString(byArray, 0, byArray.length);
    }

    private EncodingUtil() {
    }
}

