/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.auth;

import com.google.appengine.repackaged.org.apache.commons.httpclient.Credentials;
import com.google.appengine.repackaged.org.apache.commons.httpclient.Header;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpConnection;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpState;
import com.google.appengine.repackaged.org.apache.commons.httpclient.UsernamePasswordCredentials;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthChallengeParser;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthScheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthenticationException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.BasicScheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.DigestScheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.InvalidCredentialsException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.MalformedChallengeException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.NTLMScheme;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.util.HashMap;

public final class HttpAuthenticator {
    private static final Log LOG = LogFactory.getLog(HttpAuthenticator.class);
    public static final String WWW_AUTH = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";

    public static AuthScheme selectAuthScheme(Header[] headerArray) throws MalformedChallengeException {
        LOG.trace("enter HttpAuthenticator.selectAuthScheme(Header[])");
        if (headerArray == null) {
            throw new IllegalArgumentException("Array of challenges may not be null");
        }
        if (headerArray.length == 0) {
            throw new IllegalArgumentException("Array of challenges may not be empty");
        }
        String string = null;
        HashMap<String, String> hashMap = new HashMap<String, String>(headerArray.length);
        for (int i = 0; i < headerArray.length; ++i) {
            string = headerArray[i].getValue();
            String string2 = AuthChallengeParser.extractScheme(string);
            hashMap.put(string2, string);
        }
        string = (String)hashMap.get("ntlm");
        if (string != null) {
            return new NTLMScheme(string);
        }
        string = (String)hashMap.get("digest");
        if (string != null) {
            return new DigestScheme(string);
        }
        string = (String)hashMap.get("basic");
        if (string != null) {
            return new BasicScheme(string);
        }
        throw new UnsupportedOperationException("Authentication scheme(s) not supported: " + ((Object)hashMap).toString());
    }

    private static boolean doAuthenticateDefault(HttpMethod httpMethod, HttpConnection httpConnection, HttpState httpState, boolean bl) throws AuthenticationException {
        Credentials credentials;
        if (httpMethod == null) {
            throw new IllegalArgumentException("HTTP method may not be null");
        }
        if (httpState == null) {
            throw new IllegalArgumentException("HTTP state may not be null");
        }
        String string = null;
        if (httpConnection != null) {
            string = bl ? httpConnection.getProxyHost() : httpConnection.getHost();
        }
        Credentials credentials2 = credentials = bl ? httpState.getProxyCredentials(null, string) : httpState.getCredentials(null, string);
        if (credentials == null) {
            return false;
        }
        if (!(credentials instanceof UsernamePasswordCredentials)) {
            throw new InvalidCredentialsException("Credentials cannot be used for basic authentication: " + credentials.toString());
        }
        String string2 = BasicScheme.authenticate((UsernamePasswordCredentials)credentials, httpMethod.getParams().getCredentialCharset());
        if (string2 != null) {
            String string3 = bl ? PROXY_AUTH_RESP : WWW_AUTH_RESP;
            Header header = new Header(string3, string2, true);
            httpMethod.addRequestHeader(header);
            return true;
        }
        return false;
    }

    public static boolean authenticateDefault(HttpMethod httpMethod, HttpConnection httpConnection, HttpState httpState) throws AuthenticationException {
        LOG.trace("enter HttpAuthenticator.authenticateDefault(HttpMethod, HttpConnection, HttpState)");
        return HttpAuthenticator.doAuthenticateDefault(httpMethod, httpConnection, httpState, false);
    }

    public static boolean authenticateProxyDefault(HttpMethod httpMethod, HttpConnection httpConnection, HttpState httpState) throws AuthenticationException {
        LOG.trace("enter HttpAuthenticator.authenticateProxyDefault(HttpMethod, HttpState)");
        return HttpAuthenticator.doAuthenticateDefault(httpMethod, httpConnection, httpState, true);
    }

    private static boolean doAuthenticate(AuthScheme authScheme, HttpMethod httpMethod, HttpConnection httpConnection, HttpState httpState, boolean bl) throws AuthenticationException {
        Object object;
        if (authScheme == null) {
            throw new IllegalArgumentException("Authentication scheme may not be null");
        }
        if (httpMethod == null) {
            throw new IllegalArgumentException("HTTP method may not be null");
        }
        if (httpState == null) {
            throw new IllegalArgumentException("HTTP state may not be null");
        }
        String string = null;
        if (httpConnection != null) {
            if (bl) {
                string = httpConnection.getProxyHost();
            } else {
                string = httpMethod.getParams().getVirtualHost();
                if (string == null) {
                    string = httpConnection.getHost();
                }
            }
        }
        String string2 = authScheme.getRealm();
        if (LOG.isDebugEnabled()) {
            object = new StringBuffer();
            ((StringBuffer)object).append("Using credentials for ");
            if (string2 == null) {
                ((StringBuffer)object).append("default");
            } else {
                ((StringBuffer)object).append('\'');
                ((StringBuffer)object).append(string2);
                ((StringBuffer)object).append('\'');
            }
            ((StringBuffer)object).append(" authentication realm at ");
            ((StringBuffer)object).append(string);
            LOG.debug(((StringBuffer)object).toString());
        }
        Object object2 = object = bl ? httpState.getProxyCredentials(string2, string) : httpState.getCredentials(string2, string);
        if (object == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("No credentials available for the ");
            if (string2 == null) {
                stringBuffer.append("default");
            } else {
                stringBuffer.append('\'');
                stringBuffer.append(string2);
                stringBuffer.append('\'');
            }
            stringBuffer.append(" authentication realm at ");
            stringBuffer.append(string);
            throw new CredentialsNotAvailableException(stringBuffer.toString());
        }
        String string3 = authScheme.authenticate((Credentials)object, httpMethod);
        if (string3 != null) {
            String string4 = bl ? PROXY_AUTH_RESP : WWW_AUTH_RESP;
            Header header = new Header(string4, string3, true);
            httpMethod.addRequestHeader(header);
            return true;
        }
        return false;
    }

    public static boolean authenticate(AuthScheme authScheme, HttpMethod httpMethod, HttpConnection httpConnection, HttpState httpState) throws AuthenticationException {
        LOG.trace("enter HttpAuthenticator.authenticate(AuthScheme, HttpMethod, HttpConnection, HttpState)");
        return HttpAuthenticator.doAuthenticate(authScheme, httpMethod, httpConnection, httpState, false);
    }

    public static boolean authenticateProxy(AuthScheme authScheme, HttpMethod httpMethod, HttpConnection httpConnection, HttpState httpState) throws AuthenticationException {
        LOG.trace("enter HttpAuthenticator.authenticateProxy(AuthScheme, HttpMethod, HttpState)");
        return HttpAuthenticator.doAuthenticate(authScheme, httpMethod, httpConnection, httpState, true);
    }
}

