/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRdbmsProperties {
    public static final String DRIVER_PROPERTY = "rdbms.driver";
    public static final String EXTRA_DRIVER_PROPERTIES = "rdbms.extra.properties";
    public static final String JDBC_CONNECTION_URL_STRING = "rdbms.url";
    public static final String REMOTE_CLIENT_FACTORY = "rdbms.remote.client.factory";
    private static final String DEFAULT_CLIENT_FACTORY = "com.google.cloud.sql.jdbc.internal.googleapi.GoogleApiClientFactory";
    private static final String PREFS_PACKAGE = "/com/google/cloud/sqlservice";
    private static final String OAUTH2_TOKEN_KEY = "oauth2Token";
    private final Map<String, String> properties;

    LocalRdbmsProperties(Map<String, String> properties) {
        this.properties = Collections.unmodifiableMap(properties);
    }

    LocalRdbmsProperties registerDriver() throws IllegalStateException {
        try {
            String driverName = this.properties.get(DRIVER_PROPERTY);
            if (driverName == null) {
                throw new IllegalStateException(MessageFormat.format("System property {0} must be set.", DRIVER_PROPERTY));
            }
            Class<?> driverClass = Class.forName(driverName);
            try {
                DriverManager.registerDriver((Driver)driverClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (ClassNotFoundException e1) {
            throw new IllegalStateException(e1);
        }
        return this;
    }

    String getUrl() {
        return this.properties.get(JDBC_CONNECTION_URL_STRING);
    }

    String getClientFactoryClass() {
        String clientFactory = this.properties.get(REMOTE_CLIENT_FACTORY);
        return clientFactory != null ? clientFactory : DEFAULT_CLIENT_FACTORY;
    }

    Map<String, String> getExtraProperties() {
        String refreshToken;
        HashMap<String, String> map = new HashMap<String, String>();
        String extra = this.properties.get(EXTRA_DRIVER_PROPERTIES);
        if (extra != null) {
            for (String line : extra.split(",")) {
                String[] parts = line.split("=", 2);
                if (parts.length != 2) continue;
                map.put(parts[0], parts[1]);
            }
        }
        if ((refreshToken = Preferences.userRoot().node(PREFS_PACKAGE).get(OAUTH2_TOKEN_KEY, null)) != null) {
            map.put(ConnectionProperty.OAUTH2_REFRESH_TOKEN.key(), refreshToken);
        }
        return map;
    }

    public String toString() {
        return this.properties.toString();
    }
}

