package farm.example.ifrog;


import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Before;
import org.junit.Test;

import farm.example.ifrog.Station;

/**
 * @author nakajimay
 * @author mimoto
 */
public class StationTest {

	private List<Station> _stationList;
	private Map<Long, Station> _stationMap;


	/**
	 * 10件ダミーレコードを生成する
	 * 
	 * @throws Exception
	 */
	@Before
	public void setUp() throws Exception {
		_stationList = new ArrayList<Station>();
		for (int i = 0; 10 > i; i++) {
			Station rec = new Station();
			rec.setLineCd(Long.valueOf(i));
			rec.setName("駅名" + i);
			_stationList.add(rec);
		}

		_stationMap = new HashMap<Long, Station>();
		for (Station rec : _stationList) {
			_stationMap.put(rec.getLineCd(), rec);
		}
	}


	/**
	 * 比較
	 */
	@Test
	public void testCollection1() {

		for (Station rec : _stationList) {
			Station retrieved = _stationMap.get(rec.getLineCd());
			// _stationList と _stationMapにセットしたStationは同じだと思っているよの比較
			assertSame(rec, retrieved);
			assertEquals(rec, retrieved);
			
			// 同じオブジェクトであることのテスト
			rec.setLineCd(rec.getLineCd() + 1); 
			assertEquals(rec, retrieved); 
		}
	}
	
	@Test 
	public void testEquals() throws CloneNotSupportedException {
		Station s1 = new Station();
		s1.setName("foo");
		s1.setLineCd(1L);
		Station s2 = s1.clone();

		assertNotSame(s1, s2);
		assertEquals(s1, s2);
	}
	
	@Test
	public void testToString() {
		Station s1 = new Station();
		s1.setName("foo");
		s1.setLineCd(1L);
		
		assertEquals("Station: Name,LineCd=(foo,1)", s1.toString());
	}

}
