package farm.example.ifrog;


import static org.junit.Assert.*;

import java.util.List;
import java.util.Map;

import javax.cache.CacheException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.google.appengine.tools.development.testing.LocalDatastoreServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;

import farm.example.ifrog.Station;
import farm.example.ifrog.StationCache;


/**
 * 
 * @author nakajimay
 * @author mimoto
 */
public class StationCacheTest {
	
    private final LocalServiceTestHelper helper =
        new LocalServiceTestHelper(new LocalDatastoreServiceTestConfig());

    @Before
    public void setUp() {
        helper.setUp();
    }

    @After
    public void tearDown() {
        helper.tearDown();
    }
	
	/**
	 * 比較
	 */
	@Test
	public void testCollection1() {

		try {
			List<Station> stationList = StationCache.getStationList();
			Map<Long, Station> stationMap = StationCache.getStationMap();

			for (Station rec : stationList) {
				Station retrieved = stationMap.get(rec.getLineCd());

				assertNotSame(rec, retrieved);
				assertEquals(rec, retrieved);
				
				// 別オブジェクトであることのテスト
				rec.setLineCd(rec.getLineCd() + 1);
				assertFalse(rec.equals(retrieved));
			}

		} catch (CacheException e) {
			e.printStackTrace();
		}
	}

}
