/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.CallbackContext;
import com.google.appengine.api.datastore.DatastoreCallbacksImpl;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseCallbackContext<T>
implements CallbackContext<T> {
    private final AsyncDatastoreService datastoreService;
    private final List<T> elements;
    private int currentIndex;

    BaseCallbackContext(AsyncDatastoreService datastoreService, List<T> elements) {
        this.datastoreService = Preconditions.checkNotNull(datastoreService);
        this.elements = Collections.unmodifiableList(Preconditions.checkNotNull(elements));
    }

    @Override
    public List<T> getElements() {
        return this.elements;
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.datastoreService.getCurrentTransaction(null);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public T getCurrentElement() {
        return this.elements.get(this.currentIndex);
    }

    void executeCallbacks(Multimap<String, DatastoreCallbacksImpl.Callback> callbacksByKind, Collection<DatastoreCallbacksImpl.Callback> noKindCallbacks) {
        Preconditions.checkState(this.currentIndex == 0, "executeCallbacks cannot be called more than once.");
        for (T ele : this.elements) {
            Iterable<DatastoreCallbacksImpl.Callback> allCallbacksToRun = Iterables.concat(callbacksByKind.get(this.getKind(ele)), noKindCallbacks);
            for (DatastoreCallbacksImpl.Callback callback : allCallbacksToRun) {
                callback.run(this);
            }
            ++this.currentIndex;
        }
    }

    abstract String getKind(T var1);
}

