/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.io;

import com.google.appengine.repackaged.org.apache.http.ConnectionClosedException;
import com.google.appengine.repackaged.org.apache.http.HttpException;
import com.google.appengine.repackaged.org.apache.http.HttpMessage;
import com.google.appengine.repackaged.org.apache.http.HttpRequestFactory;
import com.google.appengine.repackaged.org.apache.http.ParseException;
import com.google.appengine.repackaged.org.apache.http.RequestLine;
import com.google.appengine.repackaged.org.apache.http.impl.io.AbstractMessageParser;
import com.google.appengine.repackaged.org.apache.http.io.SessionInputBuffer;
import com.google.appengine.repackaged.org.apache.http.message.LineParser;
import com.google.appengine.repackaged.org.apache.http.message.ParserCursor;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;
import com.google.appengine.repackaged.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class HttpRequestParser
extends AbstractMessageParser {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    public HttpRequestParser(SessionInputBuffer buffer, LineParser parser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, parser, params);
        if (requestFactory == null) {
            throw new IllegalArgumentException("Request factory may not be null");
        }
        this.requestFactory = requestFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected HttpMessage parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

