/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.dev.ChannelManager;
import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import com.google.appengine.api.channel.dev.LocalChannelService;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LocalChannelServlet
extends HttpServlet {
    public static final String COMMAND_PARAM = "command";
    public static final String TOKEN_PARAM = "channel";
    public static final String CONNECTION_PARAM = "client";
    private ChannelManager channelManager;

    public LocalChannelServlet() {
    }

    @VisibleForTesting
    public LocalChannelServlet(ChannelManager channelManager) {
        this.channelManager = channelManager;
    }

    String getToken(HttpServletRequest req) {
        String token = req.getParameter(TOKEN_PARAM);
        if (token != null) {
            token = token.trim();
        }
        return token;
    }

    String getConnectionId(HttpServletRequest req) {
        String connectionId = req.getParameter(CONNECTION_PARAM);
        if (connectionId != null) {
            connectionId = connectionId.trim();
        }
        return connectionId;
    }

    private LocalChannelService getLocalChannelService() {
        ApiProxyLocal proxy = (ApiProxyLocal)ApiProxy.getDelegate();
        return (LocalChannelService)proxy.getService(TOKEN_PARAM);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ChannelManager channelManager = this.channelManager;
        if (this.channelManager == null) {
            channelManager = this.getLocalChannelService().getChannelManager();
        }
        String action = req.getParameter(COMMAND_PARAM);
        String token = this.getToken(req);
        String connectionId = this.getConnectionId(req);
        if (action == null) {
            throw new LocalChannelFailureException("Action cannot be null.");
        }
        if (action.equals("connect")) {
            resp.setContentType("text/plain");
            resp.getWriter().println(channelManager.connectClient(token));
        } else if (action.equals("disconnect")) {
            channelManager.disconnectClient(token, connectionId);
        } else if (action.equals("poll")) {
            String message = channelManager.getNextClientMessage(token, connectionId);
            if (message != null) {
                resp.setContentType("text/plain");
                resp.setCharacterEncoding("UTF-8");
                resp.getWriter().println(message);
            }
        } else {
            throw new LocalChannelFailureException("Unrecognized action: " + action);
        }
    }
}

