/*
 *  Copyright (C) 2006 Masataka Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIP_WINDOW_H__
#define __TIP_WINDOW_H__

G_BEGIN_DECLS

#define TYPE_TIP_WINDOW                  (tip_window_get_type ())
#define TIP_WINDOW(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIP_WINDOW, TipWindow))
#define TIP_WINDOW_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIP_WINDOW, TipWindowClass))
#define IS_TIP_WINDOW(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIP_WINDOW))
#define IS_TIP_WINDOW_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIP_WINDOW))
#define TIP_WINDOW_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIP_WINDOW, TipWindowClass))


typedef struct _TipWindow	 TipWindow;
typedef struct _TipWindowClass   TipWindowClass;

struct _TipWindow
{
  GtkObject parent_instance;

  GtkWidget *tip_window;
  GtkWidget *tip_label;
  gchar *tip_text;
};

struct _TipWindowClass
{
  GtkObjectClass parent_class;
};

GType		 tip_window_get_type	   (void) G_GNUC_CONST;
TipWindow*	 tip_window_new 	   (void);

void		 tip_window_set_tip	   (TipWindow     *window,
					    const gchar   *tip_text);

void             tip_window_popup          (TipWindow     *window);

void             tip_window_popup_with_tip (TipWindow     *window,
					    const gchar   *tip_text);

void             tip_window_hide           (TipWindow     *window);

void             tip_window_set_stick      (TipWindow     *window,
					    gboolean       is_stick);

G_END_DECLS

#endif /* __TIP_WINDOW_H__ */
