/*
copyright (c) 2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef _LIBINTL_H
#define _LIBINTL_H


#include <locale.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>


#define LIBINTL_VERSION 0x001000
#ifndef LC_MESSAGES
# define LC_MESSAGES 1729
#endif /* not LC_MESSAGES */
#define bind_textdomain_codeset libintl_bind_textdomain_codeset
#define bindtextdomain libintl_bindtextdomain
#define dcgettext libintl_dcgettext
#define dcngettext libintl_dcngettext
#define dgettext libintl_dgettext
#define dngettext libintl_dngettext
#define gettext libintl_gettext
#define ngettext libintl_ngettext
#define textdomain libintl_textdomain


extern int libintl_version;


#ifdef __cplusplus
extern "C" {
#endif


char *
libintl_bind_textdomain_codeset (const char *domainname,
                                 const char *codeset);


char *
libintl_bindtextdomain (const char *domainname,
                        const char *dirname);


char *
libintl_textdomain (const char *domainname);


char *
libintl_dcngettext (const char *domainname,
                    const char *msgid1,
                    const char *msgid2,
                    unsigned    n,
                    int         category);


char *
libintl_gettext(const char *msgid);


char *
libintl_dgettext (const char *domainname,
                  const char *msgid);


char *
libintl_dcgettext (const char *domainname,
                   const char *msgid,
                   int         category);


char *
libintl_ngettext (const char *msgid1,
                  const char *msgid2,
                  unsigned    n);


char *
libintl_dngettext (const char *domainname,
                   const char *msgid1,
                   const char *msgid2,
                   unsigned    n);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _LIBINTL_H */
