#ifndef GAME_SYOKUNIN_COM_TINYFONT_FONT_H

#define GAME_SYOKUNIN_COM_TINYFONT_FONT_H

#include <boost/cstdint.hpp>
#include <boost/assert.hpp>

namespace TinyFont {
	///	ŒTCYQltHgNX
	/**
	 *	̃tHg܂܂Ȃ͋󔒂ƓɂB
	 *	tɌƁÃtHǵA󔒕܂łȂB
	 */
	template < boost::uint8_t Width, boost::uint8_t Height >
	class Font {
	public:
		typedef boost::uint8_t	uint8_t;
		typedef boost::uint32_t	uint32_t;

		static const uint8_t	width		= Width;
		static const uint8_t	height		= Height;
		static const uint8_t	numChars	= '~' - '!' + 1;
		static const uint32_t	bitSize		= width * height * numChars;
		static const uint32_t	byteSize	= ( bitSize + 7 ) / 8;

	private:
		const uint8_t*	bytes_;
	public:
		Font() {}
		explicit Font( const uint8_t* ioBytes ) : bytes_( ioBytes ) {}
		
		///	Ȃꍇ́AnumChars ȏ̒lԂ
		static uint8_t charToIndex( uint8_t ch ) {
			return ch > '!' ? ch - '!' : numChars;
		}
		
		///	i[obt@擪AhX擾
		const uint8_t* data() const {
			return bytes_;
		}

		///	擪 i Ԗڂ̃rbg𓾂
		bool operator [] ( uint32_t i ) const {
			return ( bytes_[ i / 8 ] >> ( i % 8 ) ) & 0x1;
		}
		
		///	ŒTCYQlC[W
		/**
		 *	i[rbgPʂł邽߁Af𓾂̂ɌvZKvłB
		 *	܂AGɂȂ邽߁A񂱂 Image Ɋi[ǍŃANZXقA
		 *	菇B
		 */
		struct Image {
			uint8_t bytes[ ( width * height + 7 ) / 8 ];
			
			Image() {}
			Image( const Image& other ) {
				memcpy( this, &other, sizeof ( Image ) );
			}
			Image& operator = ( const Image& other ) {
				memcpy( this, &other, sizeof ( Image ) );
			}
			bool operator () ( uint32_t x, uint32_t y ) const {
				return ( *this )[ y * width + x ];
			}
			
			void set( boost::uint32_t i, boost::uint8_t bit ) {
				BOOST_ASSERT( 0 == bit || 1 == bit );
				bytes[ i / 8 ] &= ( ~( 1 << ( i % 8 ) ) );
				bytes[ i / 8 ] |= ( bit << ( i % 8 ) );
			}
			
			///	擪 i Ԗڂ̃rbg𓾂
			bool operator [] ( uint32_t i ) const {
				return ( bytes[ i / 8 ] >> ( i % 8 ) ) & 0x1;
			}
		};
		
		///	nth Ԗڂ̃C[W擾
		void getImage( uint32_t nth, Image& outImage ) const {
			for ( uint32_t i = 0; i < width * height; ++i ) {
				outImage.set( i, ( *this )[ nth * width * height + i ] );
			}
		}
	};

	///	݉\tHg
	template < boost::uint8_t Width, boost::uint8_t Height >
	class WritableFont : Font< Width, Height > {
	public:
		///	i[obt@擪AhX擾
		const uint8_t* data() const {
			return Font< Width, Height >::data();
		}
		
		///	i[obt@擪AhX擾
		uint8_t* data() {
			return const_cast< uint8_t* >( Font< Width, Height >::data() );
		}
		
		///	擪 i Ԗڂ̃rbg𓾂
		bool operator [] ( uint32_t i ) const {
			return ( bytes[ i / 8 ] >> ( i % 8 ) ) & 0x1;
		}
		
		void set( boost::uint32_t i, boost::uint8_t bit ) {
			BOOST_ASSERT( 0 == bit || 1 == bit );
			
			uint8_t* dat = data();
			
			dat[ i / 8 ] &= ( ~( 1 << ( i % 8 ) ) );
			dat[ i / 8 ] |= ( bit << ( i % 8 ) );
		}
	};
}

#endif