package jp.sf.grizzly.pipeline;

import java.util.List;

import jp.sf.grizzly.pipeline.valve.Valve;
import jp.sf.grizzly.pipeline.valve.ValveContext;
import jp.sf.grizzly.storage.StreamStorage;

public class GrizzlyPipeline
{
    /**
     * Name of this pipeline.
     */
    protected String name;

    /**
     * The set of Valves associated with this Pipeline.
     */
    protected Valve[] valves;

    /**
     * Constructor that provides the descriptor for building the pipeline
     */
    public GrizzlyPipeline(String name, List valveList) throws Exception
    {
        valves = (Valve[]) valveList.toArray(new Valve[valveList.size()]);
        setName(name);
    }

    public void initialize() throws PipelineException
    {

    }

    /**
     * Set the name of this pipeline.
     * 
     * @param name
     *            Name of this pipeline.
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * Get the name of this pipeline.
     * 
     * @return String Name of this pipeline.
     */
    public String getName()
    {
        return name;
    }

    public synchronized void addValve(Valve valve)
    {
        // Add this Valve to the set associated with this Pipeline
        Valve[] results = new Valve[valves.length + 1];
        System.arraycopy(valves, 0, results, 0, valves.length);
        results[valves.length] = valve;
        valves = results;
    }

    public synchronized Valve[] getValves()
    {
        Valve[] results = new Valve[valves.length];
        System.arraycopy(valves, 0, results, 0, valves.length);
        return results;
    }

    public synchronized void removeValve(Valve valve)
    {
        // Locate this Valve in our list
        int index = -1;
        for (int i = 0; i < valves.length; i++)
        {
            if (valve == valves[i])
            {
                index = i;
                break;
            }
        }
        if (index < 0) { return; }

        // Remove this valve from our list
        Valve[] results = new Valve[valves.length - 1];
        int n = 0;
        for (int i = 0; i < valves.length; i++)
        {
            if (i == index)
            {
                continue;
            }
            results[n++] = valves[i];
        }
        valves = results;
    }

    public void invoke(StreamStorage storage) throws PipelineException
    {

        Invocation invocation;
        // TODO use java 5 locks or compare and swap if possible
        synchronized (this)
        {
            invocation = new Invocation(valves);
        }
        // Invoke the first Valve in this pipeline for this request
        invocation.invokeNext(storage);
    }

    private static final class Invocation implements ValveContext
    {

        private final Valve[] valves;

        private int at = 0;

        public Invocation(Valve[] valves)
        {
            this.valves = valves;
        }

        public void invokeNext(StreamStorage storage) throws PipelineException
        {
            if (at < valves.length)
            {
                Valve next = valves[at];
                at++;
                next.invoke(storage, this);
            }
        }
    }

}
