/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/20 14:57:21
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.CDataNode;
import jp.grain.spike.event.Event;
import jp.grain.sprout.model.InstanceElement;

public class Upload extends InlineComponent {

    public static final String NAME = "upload";
    
    private static final int COLOR_BLACK = 0x000000; // 
    private static final int COLOR_BUTTON = 0x999999; // {^wi
    private static final int COLOR_EDGE_DARK = 0x333333; // {^GbW(Áj
    private static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // {^GbW()
    private static final int COLOR_FOCUS = 0xFF6666; // {^IIF
    private static final int SIZE_BORDER = 1;
    private static final int SIZE_MARGIN = 1;
    private static final int SIZE_MINIMUM = SIZE_MARGIN + 3;
    private static final int SIZE_PADDING = 2;
    private static final int DEFAULT_SIZE = 15;
    
    private boolean _pressed;
    
    public Upload() {
        super(NAME);
        _margin = SIZE_MARGIN;
        _border = SIZE_BORDER;
        _padding = SIZE_PADDING;
    }    
    
   public void applySelf(Form form) {
        super.applySelf(form);
        if (_label != null && _width < 0) _width = _label.getBoxWidth();
        if (_width < SIZE_MINIMUM) _width = SIZE_MINIMUM;
        if (_label != null && _height < _label.getBoxHeight()) _height = _label.getBoxHeight();
        if (_height < 0) _height = DEFAULT_SIZE;
        if (_width < 0) _width = DEFAULT_SIZE;        
    }

    public void draw(DrawContext dc) {
		System.out.println("DRAW: this[dc.y="+dc.getY()+", box.y="+getBoxHeight()+"]="+this.getClass().getName());
		if(dc.getY()+getBoxHeight() < 0 || dc.getY() > getOwnerForm().getContext().getHeight()) return ;
        dc.setEmbossParam(_border, COLOR_BUTTON, COLOR_EDGE_LIGHT, COLOR_EDGE_DARK, _pressed);
        dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2, _height + (_padding + _border) * 2);
        if (getOwnerForm().isFocusingOn(this)) {
            dc.setColor(COLOR_FOCUS);
            dc.drawRect(0, 0, getBoxWidth() - 1, getBoxHeight() - 1);
        }
        dc.setColor(COLOR_BLACK);
        dc.clipRect(getContentX(), getContentY(), getWidth(), getHeight());
        if (_label != null) {
            dc.drawString(_label.getText(), getContentX(), getContentY());
        }
        dc.clearClip();
    }

    /*
    public boolean handleAction(FormContext view, int action, int selector) {
        super.handleAction(view, action, selector);
        if (selector == FormContext.SEL_SELECT) {
            if (action == FormContext.ACT_PRESSED) {
                this._pressed = true;
                view.launchCameraDevice();
                InstanceElement element = (InstanceElement)this.getBindingNode();
                CDataNode cdatanode = new CDataNode();
                cdatanode.setData(view.getCameraData());
                cdatanode.setParent(element);
                element.addChild(cdatanode);
                
                return true;
            } else if (action == FormContext.ACT_RELEASED) {
                this._pressed = false;
                return true;
            }
        }
        return false;
    }
    */
    
    public boolean handleEvent(Event event) {
		if(super.handleEvent(event)) return true;
		
		if(event.getType() == Event.TYPE_DOMACTIVATE) {
            event.getContext().launchCameraDevice();
            InstanceElement element = (InstanceElement)this.getBindingNode();
            
            CDataNode cdatanode = new CDataNode();
            cdatanode.setData(event.getContext().getCameraData());
            
            if(element.getChildCount() != 0){
            	for(int i=0; i<element.getChildCount(); i++)
            		element.removeChild(i);
            }
            
            cdatanode.setParent(element);
            element.addChild(cdatanode);
            ((Form)getDocument()).notifyEvent(new Event(Event.TYPE_GRAIN_INPUT_COMMITED, this, event));

    		event.getContext().requestRender();
            return true;
		}

		return false;
	}

	public boolean hasOuterLabel() {
        return false;
    }
}
