/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/23 7:37:14
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.event.Event;
import jp.grain.spike.event.FocusListener;

/**
 * TODO Choice
 * 
 * @version $Id: TabBlock.java 392 2006-06-29 06:24:23Z nakajo $
 * @author Go Takahashi
 */
public class TabBlock extends Block implements FocusListener {

	public static final String NAME = "tab-bar";

	private static final int COLOR_BLACK = 0x000000; // 
	private static final int COLOR_BUTTON = 0x999999; // {^wi
	private static final int COLOR_EDGE_DARK = 0x333333; // {^GbW(Áj

	private static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // {^GbW()
	private static final int COLOR_FOCUS = 0xFF6666; // {^IIF
	private static final int COLOR_FIELD = 0xFFFFFF; // wi
	private static final int SIZE_BORDER = 1;
	private static final int SIZE_MARGIN = 0;
	private static final int SIZE_PADDING = 2;

    /** ̃R|[lgɃtH[JXĂ邩ǂ */
	private boolean _focusin;
	
	private int _currentIndex = 0;
	private int _tabWidth;
	private int _tabHeight;
	private int _drawStartIndex = 0;
	private int[] _blockWidthList;
	private int trueTabHeight = 0;

	/** ̃hLg̐\\zFormUirQ[Vp̘A */
	private int _navigationIndex = FocusListener.DEFAULT_NAVI_INDEX;

	public TabBlock() {
		super(NAME);
		_margin = SIZE_MARGIN;
		_border = SIZE_BORDER;
		_padding = SIZE_PADDING;
	}

	protected void applySelf(Form form) {
		_blockWidthList = new int[getChildCount()];
		super.applySelf(form);
		if ("upper".equals(getAttribute("tab"))) {
			form.registeNavigation(getNavigationIndex(), this);
			_tabHeight = Font.getDefaultFont().getHeight();
			int contentWidth = _border;

			for (int i = _drawStartIndex; i < getChildCount(); ++i) {
				Block block = (Block) getChildElement(i);
				Inline label = block.getLabel();
				if (_currentIndex < 0 && "true".equals(block.getAttribute("selected"))) {
					_currentIndex = i;
				}
				label.apply(form);
				contentWidth += label.getBoxWidth() + _padding * 2 + _border;
				//                
				_blockWidthList[i] = contentWidth;
				
				if (label.getBoxHeight() > _tabHeight) {
					_tabHeight = label.getBoxHeight();
				}
				// //2006.6.14
				// " _width=" + _width + " _tabWidth=" + _tabWidth + " (_border
				// + _padding) * 2=" +(_border + _padding) * 2);
			}

			// if (contentWidth - (_border + _padding) * 2 > _width) {
			// contentWidth = _width - (_padding * 2 + _border) *
			// (getChildCount() - 1);
			// _tabWidth = contentWidth / getChildCount();
			// }

			
			_height += _tabHeight + _padding * 2 + _border + _border + _padding;
			trueTabHeight = _height - _border - _padding;;
			
		}
	}
	

	protected void applyChildren(Form form) {
		
		for (int i = 0; i < _children.size(); ++i) {
			Box box = (Box) _children.elementAt(_currentIndex);
			if (i == _currentIndex) {
				box.setRelativePosition(0, _height);
				box.apply(form);
				_height += box.getBoxHeight();
			}
		}
		
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
	 */
	public void draw(DrawContext dc) {	
		System.out.println("DRAW: this[dc.y="+dc.getY()+", box.y="+getBoxHeight()+"]="+this.getClass().getName());	
		if(dc.getY()+getBoxHeight() < 0 || dc.getY() > getOwnerForm().getContext().getHeight()) return ;
		dc = dc.createContext();
		int bgColor = dc.getColorByHex(getInheritedAttribute("background-color"));
		int x = _margin;
		int y = _margin;
		int outer = (_padding + _border)*2;
		
		dc.setColor(DEFAULT_BG_COLOR);
		dc.fillRect(x, y, getBoxWidth() - _margin * 2, getBoxHeight() - _margin * 2);
		
		for (int i = _drawStartIndex; i < getChildCount(); ++i) {
			Block block = (Block) getChildElement(i);

			int width = (_tabWidth > 0) ? _tabWidth : block.getLabel().getWidth();

			int height = _tabHeight;
			if (i == _currentIndex) {
				dc.moveTo(x, y);
				dc.setColor((bgColor < 0) ? DEFAULT_BG_COLOR : bgColor);
			} else {
				dc.setColor(DEFAULT_BG_COLOR);
				height -= 1;
				dc.moveTo(x, y + 1);
			}
			int offset = i > 0 && i != _currentIndex ? _border : 0;
			dc.clipRect(offset, 0, width + outer - offset, height + outer);
			dc.fillRect(0, 0, width + outer, height + outer);
			dc.setColor(COLOR_BLACK);

			if (_border > 0) {
				dc.setColor(COLOR_EDGE_LIGHT);
				dc.drawLine(0, 0, width + outer - 1, 0);
				dc.setColor(COLOR_EDGE_DARK);
				dc.drawLine(width + outer - 1, 0, width + outer - 1, height + outer - 1);
			}

			if (_focusin && i == _currentIndex) {
				dc.setColor(COLOR_FOCUS);
				dc.drawLine(0, _border, width + _padding * 2, _border);
			}

			dc.setView(_border, _border);
			dc.clipRect(0, 0, width + _padding * 2, height + _padding * 2);
			dc.setView(_border + _padding, _border + _padding);
			dc.setColor(COLOR_BLACK);
			block.getLabel().draw(dc);
			// dc.drawString(block.getLabel(), 0, 0);
			x += width + outer - _border;
			dc.clearClip();
		}
		x = _margin;
		y = _margin + _tabHeight + outer;
		dc.moveTo(x, y);
		dc.setColor((bgColor < 0) ? DEFAULT_BG_COLOR : bgColor);
		dc.fillRect(0, 0, getBoxWidth() - x - _margin, getBoxHeight() - y - _margin);

		if (_currentIndex < 0) return;
		dc.moveTo(0, 0);
		DrawContext childCtx = dc.createContext(getContentX(), getContentY());
		Box child = (Box) _children.elementAt(_currentIndex);
		
		child.draw(childCtx);
		//child.draw(childCtx.moveTo(child.x, child.y));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.haw.grain.sprout.InlineElement#action(int, int)
	 */
	public boolean handleAction(FormContext view, int action, int selector) {
		switch (action) {
		case FormContext.ACT_RELEASED:
			if (selector == FormContext.SEL_RIGHT) {
				if (_currentIndex + 1 < getChildCount()) {
					_currentIndex++;
				}
				_drawStartIndex = getDrawStartIndex(true, _drawStartIndex, _currentIndex);
				// //2006.6.14
				view.requestRefresh();
				view.requestRender();
			} else if (selector == FormContext.SEL_LEFT) {
				if (_currentIndex - 1 >= 0) {
					_currentIndex--;
				}
				_drawStartIndex = getDrawStartIndex(false, _drawStartIndex, _currentIndex);
				// //2006.6.14
				view.requestRefresh();
				view.requestRender();
			} else {
				return false;
			}
			break;
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.grain.sprout.ui.ActionHandler#isCaptureEnable()
	 */
	public boolean isCaptureEnable() {
		return true;
	}

	public int getNavigationIndex() {
		return this._navigationIndex;
	}

	public void setNavigationIndex(int navigationIndex) {
		this._navigationIndex = navigationIndex;
	}

	private int getDrawStartIndex(boolean director, int _drawStartIndex, int _currentIndex) {
		// //2006.6.14
		// _currentIndex=" + _currentIndex);
		if (director) {
			if ((_currentIndex > 1) && (_blockWidthList[_currentIndex] - _blockWidthList[_currentIndex - 1] > _width)) return _currentIndex;
			if (_blockWidthList[_currentIndex] > _width) {
				_drawStartIndex++;
				while (_blockWidthList[_currentIndex] - _blockWidthList[_drawStartIndex - 1] > _width)
					_drawStartIndex++;
				return _drawStartIndex;
			} else return _drawStartIndex;
		} else {
			if (_currentIndex > _drawStartIndex) {
				return _drawStartIndex;
			} else return _currentIndex;
		}
	}

	public String[] getHandleEvents() {
		String[] events = new String[14];
		// 4.2 Cxg
		//events[0] = Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE;
		// 4.3 ݍpCxg
		events[1] = Event.TYPE_XFORMS_HELP;
		events[2] = Event.TYPE_XFORMS_HINT;
		// 4.4 ʒmCxg
		events[3] = Event.TYPE_XFORMS_VALUE_CHANGED;
		events[4] = Event.TYPE_XFORMS_VALID;
		events[5] = Event.TYPE_XFORMS_INVALID;
		events[6] = Event.TYPE_XFORMS_READONLY;
		events[7] = Event.TYPE_XFORMS_READWRITE;
		events[8] = Event.TYPE_XFORMS_REQUIRED;
		events[9] = Event.TYPE_XFORMS_OPTIONAL;
		events[10] = Event.TYPE_XFORMS_ENABLED;
		events[11] = Event.TYPE_XFORMS_DISABLED;
		events[12] = Event.TYPE_XFORMS_IN_RANGE;
		events[13] = Event.TYPE_XFORMS_OUT_OF_RANGE;

		// g Rg[Cxg
		// events[14] = Event.TYPE_GRAIN_ACTION_EVENT;

		return events;
	}

	public boolean dispatchEvent(Event event) {
		/*
    	for(int i=0; i<_actions.size(); i++) {
    		Send send = (Send)_actions.elementAt(i);
    		send.isHandlableEvent(event.getType());
    	}*/
		return handleEvent(event);
	}

	public boolean handleEvent(Event event) {
		if (event.getType() == Event.TYPE_XFORMS_MODEL_CONSTRUCT_DONE) {
			//2006.6.14
			init((Form) event.getOwner());
		} else if (event.getType() == Event.TYPE_GRAIN_RIGHT) {
			if (_currentIndex + 1 < getChildCount()) {
				_currentIndex++;
			}
			_drawStartIndex = getDrawStartIndex(true, _drawStartIndex, _currentIndex);
			// //2006.6.14
			event.getContext().requestRefresh();
			event.getContext().requestRender();
			return true;
		} else if (event.getType() == Event.TYPE_GRAIN_LEFT) {
			if (_currentIndex - 1 >= 0) {
				_currentIndex--;
			}
			_drawStartIndex = getDrawStartIndex(false, _drawStartIndex, _currentIndex);
			// //2006.6.14
			event.getContext().requestRefresh();
			event.getContext().requestRender();
			return true;
		} else if(event.getType() == Event.TYPE_DOMFOCUSIN) {
			this._focusin = true;
			event.getContext().moveTo(0, this.y, trueTabHeight);
		} else if(event.getType() == Event.TYPE_DOMFOCUSOUT) {
			this._focusin = false;
		}
		
		return false;
	}

    public int getContentY() {
        return trueTabHeight + this._border + this._padding;
    }
}
