package jp.grain.sprout.ui;

import jp.grain.spike.Node;
import jp.grain.spike.event.FocusListener;

public class Repeat extends InlineGroup {

	public static final String NAME = "repeat";

	private int _startIndex;
	private int _number;
	private InlineGroup _originalGroup;

	public Repeat() {
		super(Repeat.NAME);
	}

	protected void initAttribute(Form form) {
		super.initAttribute(form);
		this._startIndex = getAttributeByInt("startindex", 1);
		this._number = getAttributeByInt("number", -1);
	}

	public void initChildren(Form form) {
		if (this._number < 0 && this._bindingNodeset == null) {
			this._number = 0;
		}

		Node[] nodeset = getBindingNodeset();
		if (this._originalGroup == null) {
			this._originalGroup = new InlineGroup();
			for (int i = 0; i < getChildCount(); i++) {
				if (getChild(i) instanceof String) {
					this._originalGroup.setText((String) getChild(i));
				} else {
					this._originalGroup.addChild((Node) getChild(i));
				}
			}
		}

		this._children.removeAllElements();
		if (this._number == 0) return;
		if(this._number < 0) {
			this._number = this._bindingNodeset.length;
		}

		InlineGroup repeatGroup = null;
		int index = _startIndex - 1;
		for (int i = index; i < index + _number; i++) {
			form.pushContextNode(nodeset[i]);

			repeatGroup = (InlineGroup) this._originalGroup.clone(this.getDocument());
			addChild(repeatGroup);
			// q͖ĕ]B
			// ĕ]KvȂƂ͂̃\bȟĂ΂Ȃ͂B
			repeatGroup.requestEvaluate();
			repeatGroup.init(form);

			form.popContextNode();
		}
	}

	/**
	 * ݂̌JԂindexԍԂ܂B
	 * 
	 * @param component
	 * @return
	 */
	public int getIndex() {
		FocusListener component = getOwnerForm().getFocusedComponent();
		for (int i = 0; i < getChildCount(); i++) {
			InlineGroup child = (InlineGroup) getChildElement(i);
			if (child.contains((Node) component)) return (i + 1);
		}
		return getChildCount();
	}

	protected void applyChildren(Form form) {
		System.out.println("fitWithIn(Row): number="+_number);
		if (this._number == 0) return;
		super.applyChildren(form);
	}
}
