/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/23 7:37:14
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.sprout.model.InstanceElement;

/**
 * TODO Choice
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Choice extends SelectComponent {

	public static final String NAME = "choice";
	private int displayChild = 0;
	private boolean ovreFlag = false;

	public Choice() {
		super(NAME);
		this._isMultiple = false;

	}

	public void draw(DrawContext dc) {
		System.out.println("DRAW: this[dc.y="+dc.getY()+", box.y="+getBoxHeight()+"]="+this.getClass().getName());
		if(dc.getY()+getBoxHeight() < 0 || dc.getY() > getOwnerForm().getContext().getHeight()) return ;
		
		System.out.println("DRAW: this="+this.getClass().getName());
		int sx, sy, sw, sh;

		// DavidHou
		if ((displayChild = this._itemContainer.getItems().length) > SelectComponent.MAX_DISPLAY_CHILD_COUNT) {
			ovreFlag = true;
			displayChild = SelectComponent.MAX_DISPLAY_CHILD_COUNT - 1;
		}

		dc.clearClip();
		sw = _width + (_padding + _border) * 2;

		// DavidHou
		if (ovreFlag)
			sh = (_height + _padding * 2) * (displayChild + 1) + _border * 2;
		else sh = (_height + _padding * 2) * displayChild + _border * 2;

		dc.setEmbossParam(_border, COLOR_FIELD, COLOR_EDGE_DARK, COLOR_EDGE_LIGHT, false);
		dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2, _height + (_padding + _border) * 2);

		InstanceElement node = getBindingInstanceElement();
		// disablȅ
		if (node != null && !node.isRelevant()) {
			dc.setColor(0xD2D2D2);
			dc.fillRect(_margin + _border, _margin + _border, _width + (_padding*2 + _border), _height + (_padding*2 + _border));
			dc.setColor(COLOR_BLACK);
		} else {
			// XN[o[̕`
			dc.setEmbossParam(SIZE_ARROW_EDGE, COLOR_BUTTON, COLOR_EDGE_LIGHT, COLOR_EDGE_DARK, _pressed || _activate);
			int ax = _margin + _border + _padding * 2 + _width - SIZE_ARROW;
			int ay = _margin + _border;
			dc.drawEmbossedRect(ax, ay, SIZE_ARROW, _height + _padding * 2);
			// XN[o[̕` ܂

			final int px = ax + SIZE_ARROW_EDGE + 1;
			final int pw = SIZE_ARROW - (SIZE_ARROW_EDGE + 1) * 2;
			final int py = ay + ((_height + _padding * 2) - pw) >> 1;
			int xpoints[] = new int[] { px, px + (pw >> 1), px + pw - 1 };
			int ypoints[] = new int[] { py, py + pw - 1, py };
			dc.fillPolygon(xpoints, ypoints, 3);
			if (this._focusin && !_activate) {
				dc.setColor(COLOR_FOCUS);
				dc.drawRect(0, 0, getBoxWidth() - 1, getBoxHeight() - 1);
			}
		}
		dc.setColor(COLOR_BLACK);
		if (this._itemContainer.getItems().length == 0) return;
		String text = this._itemContainer.getItemAt(_selectionIndex).getLabel();
		dc.clipRect(getContentX(), getContentY(), _width - SIZE_ARROW, _height);
		dc.drawString((text != null) ? text : "", getContentX(), getContentY());
		dc.clearClip();

		// required̏
		if (node != null && node.isRequired()) {
			dc.setColor(0xFF0000);
			dc.drawString("*", getBoxWidth() + 1, getContentY());
		}

		if (!_activate || this._itemContainer.getItems().length == 0) return;
		sx = _margin;
		sy = getBoxHeight() - _margin;

		drawPopupList(dc.createFloatingContext(sx, sy, sw, sh), sw, sh);
	}

	private void drawPopupList(DrawContext dc, int width, int height) {
		dc.setEmbossParam(_border, COLOR_FIELD, COLOR_EDGE_DARK, COLOR_EDGE_LIGHT, false);
		dc.drawEmbossedRect(0, 0, width, height);
		dc.setEmbossParam(SIZE_ARROW_EDGE, COLOR_BUTTON, COLOR_EDGE_LIGHT, COLOR_EDGE_DARK, false);

		// XN[o[̃XN[
		int embossY = _border;
		int embossHeight = height - _border * 2;
		int addHeight = 0;
		int childCount = this._itemContainer.getItems().length;
		if (SelectComponent.MAX_DISPLAY_CHILD_COUNT < childCount) {
			int scrollStep = childCount - SelectComponent.MAX_DISPLAY_CHILD_COUNT;
			addHeight = embossHeight / childCount;
			embossHeight = embossHeight - (addHeight * scrollStep);
			System.out.println("CHOICE: maxHeight=" + (_height + _padding * 2));
			System.out.println("CHOICE: addHeight=" + addHeight);
		}
		embossY = _border + (addHeight * this.displayStart);

		dc.drawEmbossedRect(_border + _padding * 2 + _width - SIZE_ARROW, embossY, SIZE_ARROW, embossHeight);
		// XN[o[̃XN[ ܂

		int sx = _border;
		int sy = _border;
		int sw = _padding * 2 + _width - SIZE_ARROW;
		int sh = _padding * 2 + _height;

		// DavidHou
		for (int i = this.displayStart; i < this.displayEnd; ++i) {
			if (i >= childCount) break;
			Item item = this._itemContainer.getItemAt(i);
			dc.clipRect(sx, sy, sw, sh);
			if (i == _currentIndex) {
				dc.setColor(COLOR_FOCUS);
				dc.fillRect(sx, sy, sw, sh);
				dc.setColor(COLOR_FIELD);
			} else {
				dc.setColor(COLOR_BLACK);
			}
			dc.clipRect(sx, sy, sw - _padding, sh);
			dc.drawString(item.getLabel(), sx + _padding, sy + _padding);
			sy += sh;
		}
	}

}
