package jp.grain.sprout.model;

import jp.grain.spike.Node;
import jp.grain.spike.xpath.XPathEvaluator;
import jp.grain.spike.xpath.XPathExpr;
import jp.grain.sprout.BindingElement;
import jp.grain.sprout.ui.Form;

public class Bind extends BindingElement {
    
    public static final String NAME = "bind";
    public static final Bind DEFAULT_BIND = new Bind();
    
    public static final String TYPE_STRING = "string";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_BOOLEAN = "boolean";
    
    private String _type;
    private XPathExpr _readonlyExpr;
    private XPathExpr _requiredExpr;
    private XPathExpr _relevantExpr;
    private XPathExpr _constraintExpr;
    private XPathExpr _calculateExpr;
    
    private boolean _readonly;
    private boolean _required;
    private boolean _relevant;
    private boolean _constraint;
    private int _calculate;
    
    public Bind() {
        super(NAME);
        this._type = Bind.TYPE_STRING;
        this._readonly = false;
        this._required = false;
        this._relevant = true;
        this._constraint = true;
        this._calculate = 0;
    }

	protected void initAttribute(Form form) {
	}

	protected void initChildren(Form form) {
	}

	public void reBuild() {
		
	}
	
	public void reCalculate() {
    	if(this._calculateExpr != null) {
    		Integer result = XPathEvaluator.evaluate(getBindingNode(), this._calculateExpr).number();
    		this._calculate = 0;
    		if(result != null) {
    			this._calculate = result.intValue();
    		}
    		return;
    	}
    	this._calculate = 0;
	}
	
	public void checkReadonly() {
    	if(this._readonlyExpr != null) {
    		this._readonly = XPathEvaluator.evaluate(getBindingNode(), this._readonlyExpr).bool();
    	}
	}
	
	public void checkRequired() {
    	if(this._requiredExpr != null) {
    		this._required = XPathEvaluator.evaluate(getBindingNode(), this._requiredExpr).bool();
    	}
	}
	
	public void checkRelevant() {
    	if(this._relevantExpr != null) {
    		this._relevant = XPathEvaluator.evaluate(getBindingNode(), this._relevantExpr).bool();
    	}
	}
	
	public void checkConstraint() {
    	if(this._constraintExpr != null) {
    		this._constraint = XPathEvaluator.evaluate(getBindingNode(), this._constraintExpr).bool();
    	}
	}
	
	/**
	 * bindvfQƂĂNodesetɂ̃CX^X킷fړ֘At܂
	 *
	 */
	public void bindingProperty() {
		if(this._bindingNodeset == null) return;
		for(int i=0; i<this._bindingNodeset.length; i++) {
			if(!(this._bindingNodeset[i] instanceof InstanceElement)) continue;
			InstanceElement node = (InstanceElement)this._bindingNodeset[i];
	    	if(this._type != null) {
	    		node.setTypeProperty(this);
	    	}
	    	if(this._readonlyExpr != null) {
	    		node.setReadonlyProperty(this);
	    	}
	    	if(this._requiredExpr != null) {
	    		node.setRequiredProperty(this);
	    	}
	    	if(this._relevantExpr != null) {
	    		node.setRelevantProperty(this);
	    	}
	    	if(this._constraintExpr != null) {
	    		node.setConstraintProperty(this);
	    	}
	    	if(this._calculateExpr != null) {
	    		node.setCalculateProperty(this);
	    	}
		}
	}
	
	public void preProcess(Node parent) {
		if(parent instanceof Model) {
			((Model)parent).addBind(this);
		}
	}
    
	public boolean isReadonly() {
		
		return this._readonly;
	}
	
	public boolean isRequired() {
		return this._required;
	}
	
	public boolean isRelevant() {
		return this._relevant;
	}
	
	public boolean isConstraint() {
		return this._constraint;
	}

	public String getType() {
		return this._type;
	}
	
	public int calculate() {
    	return this._calculate;
	}
	
	public void setBindingExpr(String name, XPathExpr binding) {
		if("readonly".equals(name)) {
			this._readonlyExpr = binding;
		} else if("required".equals(name)) {
			this._requiredExpr = binding;
		} else if("relevant".equals(name)) {
			this._relevantExpr = binding;
		} else if("constraint".equals(name)) {
			this._constraintExpr = binding;
		} else if("calculate".equals(name)) {
			this._calculateExpr = binding;
		} else {
			this._bindingExpr = binding;
		}
        if(binding != null) binding.setParent(this);
	}
}
