package jp.grain.spike.xpath;

import jp.grain.spike.Node;
import jp.grain.spike.xpath.XPathEvaluator.Frame;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.ui.Repeat;

public class XFormsFunctionLibrary implements XPathFunctionLibrary {

	// 7.7 Boolean Functions
	public static final String FUNC_BOOLEAN_FROM_STRING = "boolean-from-string";
	public static final String FUNC_IF = "if";

	// 7.8 Number Functions
	public static final String FUNC_AVG = "avg";
	public static final String FUNC_MIN = "min";
	public static final String FUNC_MAX = "max";
	public static final String FUNC_COUNT_NON_EMPTY = "count-non-empty";
	public static final String FUNC_INDEX = "index";

	// 7.9 String Functions
	// public static final String FUNC_PROPERTY = "property";

	// 7.10 Date and Time Functions
	/*
	 * public static final String FUNC_NOW = "now"; public static final String
	 * FUNC_DAYS_FROM_DATE = "days-from-date"; public static final String
	 * FUNC_SECONDS_FROM_DATETIME = "seconds-from-dateTime"; public static final
	 * String FUNC_SECONDS = "seconds"; public static final String FUNC_MONTHS =
	 * "months";
	 */

	// 7.11 Node-set Functions
	public static final String FUNC_INSTANCE = "instance";

	// 7.12 Extension Functions
	// no implementation

	public boolean call(String funcName, Frame f, int argc) {
		f.initBuffer();

		if (FUNC_BOOLEAN_FROM_STRING.equals(funcName)) {
			f.loadArgs(1);
			String arg = CoreFunctionLibrary.string(f.getArg(0)).toLowerCase();
			f.storeBoolean("true".equals(arg) || "1".equals(arg));
		} else if (FUNC_IF.equals(funcName)) {
			f.loadArgs(3);
			boolean bool = CoreFunctionLibrary.bool(f.getArg(0));
			if (bool) {
				f.store(f.getArg(1));
			} else {
				f.store(f.getArg(2));
			}
		} else if (FUNC_AVG.equals(funcName)) {
			f.loadArgs(1);
			Node[] nodeset = CoreFunctionLibrary.nodeset(f.getArg(0));
			Integer sum = CoreFunctionLibrary.sum(nodeset);
			if (sum == null) {
				f.storeNumber(null);
			} else {
				f.storeNumber(sum.intValue() / nodeset.length);
			}
		} else if (FUNC_MIN.equals(funcName)) {
			f.loadArgs(1);
			Node[] nodeset = CoreFunctionLibrary.nodeset(f.getArg(0));
			if (nodeset == null || nodeset.length == 0) {
				f.storeNumber(null);
			} else {
				int result = Integer.MAX_VALUE;
				for (int i = 0; i < nodeset.length; i++) {
					Integer num = CoreFunctionLibrary.number(nodeset[i]);
					if (num == null) {
						f.storeNumber(null);
						break;
					} else {
						result = result > num.intValue() ? num.intValue() : result;
					}
				}

				f.storeNumber(result);
			}
		} else if (FUNC_MAX.equals(funcName)) {
			f.loadArgs(1);
			Node[] nodeset = CoreFunctionLibrary.nodeset(f.getArg(0));
			if (nodeset == null || nodeset.length == 0) {
				f.storeNumber(null);
			} else {
				int result = Integer.MIN_VALUE;
				for (int i = 0; i < nodeset.length; i++) {
					Integer num = CoreFunctionLibrary.number(nodeset[i]);
					if (num == null) {
						f.storeNumber(null);
						break;
					} else {
						result = result < num.intValue() ? num.intValue() : result;
					}
				}

				f.storeNumber(result);
			}
		} else if (FUNC_COUNT_NON_EMPTY.equals(funcName)) {
			f.loadArgs(1);
			Node[] nodeset = CoreFunctionLibrary.nodeset(f.getArg(0));
			if (nodeset == null || nodeset.length == 0) {
				f.storeNumber(0);
			} else {
				int result = 0;
				for (int i = 0; i < nodeset.length; i++) {
					String s = CoreFunctionLibrary.string(nodeset[i]);
					if (s.length() > 0) result++;
				}

				f.storeNumber(result);
			}
		} else if (FUNC_INDEX.equals(funcName)) {
			f.loadArgs(1);
			String id = CoreFunctionLibrary.string(f.getArg(0));
			Node target = f.getForm().findNodeById(id);
			if (target instanceof Repeat && target != null) {
				f.storeNumber(((Repeat) target).getIndex());
			} else {
				f.storeNumber(null);
			}
		} else if (FUNC_INSTANCE.equals(funcName)) {
			f.loadArgs(1);
			String id = CoreFunctionLibrary.string(f.getArg(0));
			Node target = f.getForm().findNodeById(id);
			if (target instanceof Instance && target != null) {
				f.store(new Node[] { ((Instance) target).getDocument().getRootElement() });
			} else {
				f.store(new Node[0]);
			}
		} else {
			return false;
		}

		return true;
	}

}
