package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


/**
 * XHTMLdivvfXFormsgroupvfgudblockvfɕϊ܂Bׂ͂ăRs[܂B
 * @author nakajo
 */
public class DivAndGroup2Block extends AbstractTransformer {

	public DivAndGroup2Block(GudBuilder builder) {
		super(builder);
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#isTarget(org.w3c.dom.Node)
	 */
	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		
		return isDiv(node) || isGroup(node);
	}

	protected boolean isDiv(Node node) {
		Element e = (Element)node;
		if(e.getNamespaceURI() != GudBuilder.XHTML_NS) return false;
		
		return e.getLocalName().equals("div");
	}
	
	protected boolean isGroup(Node node) {
		Element e = (Element)node;
		if(e.getNamespaceURI() != GudBuilder.XFORMS_NS) return false;
		
		return e.getLocalName().equals("group");
	}
	
	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#transform(org.w3c.dom.Node, org.w3c.dom.Document)
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		DocumentFragment df = dom.createDocumentFragment();
		Element org = (Element)this.node;
		Element gud = dom.createElementNS(GudBuilder.GUD_NS, "block");
		
		//ׂăRs[
		Util.copyAttributes(org, gud);
		df.appendChild(gud);
		this.current = gud;
		
		return df;
		
	}
	
	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#getCurrentNode()
	 */
	public Element getCurrentElement() {
		// TODO ꂽ\bhEX^u
		return this.current;
	}

}
