package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;
import jp.haw.grain.xpath.compiler.ParseException;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Action2Action extends AbstractTransformer {

	/** ANVvf */
	public static final String ACTION_ACTION = "action";
	public static final String ACTION_DISPATCH = "dispatch";
	public static final String ACTION_RWBUILD = "rebuild";
	public static final String ACTION_RECALCULATE = "recalculate";
	public static final String ACTION_REVALIDATE = "revalidate";
	public static final String ACTION_REFRESH = "refresh";
	public static final String ACTION_SETFOCUS = "setfocus";
	public static final String ACTION_LOAD = "load";
	public static final String ACTION_SETVALUE = "setvalue";
	public static final String ACTION_SEND = "send";
	public static final String ACTION_RESET = "reset";
	public static final String ACTION_MESSAGE = "message";

	public static final String ACTION_INSERT = "insert";
	public static final String ACTION_DELETE = "delete";
	public static final String ACTION_SETINDEX = "setindex";

	public static final String[] ACTION_LIST = new String[] { ACTION_ACTION, ACTION_DISPATCH, ACTION_RWBUILD, ACTION_RECALCULATE, ACTION_REVALIDATE,
			ACTION_REFRESH, ACTION_SETFOCUS, ACTION_LOAD, ACTION_SETVALUE, ACTION_SEND, ACTION_RESET, ACTION_MESSAGE, ACTION_INSERT, ACTION_DELETE,
			ACTION_SETINDEX };

	public Action2Action(GudBuilder builder) {
		super(builder);
	}

	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTarget(Node node) {
		if (node.getNodeType() != Node.ELEMENT_NODE) return false;

		Element e = (Element) node;
		if (e.getNamespaceURI() != GudBuilder.XFORMS_NS) return false;

		return isActionName(e.getLocalName());
	}

	private boolean isActionName(String name) {
		for (int i = 0; i < ACTION_LIST.length; i++) {
			if (ACTION_LIST[i].equals(name)) return true;
		}

		return false;
	}

	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		DocumentFragment df = dom.createDocumentFragment();
		Element gud_action = dom.createElementNS(GudBuilder.GUD_NS, "action");
		Element xforms_action = (Element) node;

		// gudvfxformsvf̑Rs[
		// ref΃oCgR[hɓWJ
		Util.copyAttributes(xforms_action, gud_action);
		try {
			String[] targetAttrs = new String[0];
			if (xforms_action.getLocalName().equals(ACTION_LOAD)) {
				targetAttrs = new String[] { "ref" };
			} else if (xforms_action.getLocalName().equals(ACTION_SETVALUE)) {
				targetAttrs = new String[] { "ref", "value" };
			} else if (xforms_action.getLocalName().equals(ACTION_MESSAGE)) {
				targetAttrs = new String[] { "ref" };
			} else if (xforms_action.getLocalName().equals(ACTION_INSERT)) {
				targetAttrs = new String[] { "nodeset", "at" };
			} else if (xforms_action.getLocalName().equals(ACTION_DELETE)) {
				targetAttrs = new String[] { "nodeset", "at" };
			} else if (xforms_action.getLocalName().equals(ACTION_SETINDEX)) {
				targetAttrs = new String[] { "index" };
			}
			Util.compileNodeBinding(gud_action, targetAttrs);
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}

		// dispatch ANV nameeventtypeɕύX
		if (xforms_action.getLocalName().equals(ACTION_DISPATCH)) {
			if (xforms_action.getAttribute("name") != null) gud_action.setAttribute("eventtype", xforms_action.getAttribute("name"));
		}

		// actionnameɐݒ
		gud_action.setAttribute("name", xforms_action.getLocalName());

		// actionvf̂Ƃq̂currentɐݒ
		if (xforms_action.getLocalName().equals(ACTION_ACTION)) {
			this.current = gud_action;
		} else {
			Node parent = xforms_action.getParentNode();
			if (parent == null || !(parent.getLocalName().equals("action") && parent.getNamespaceURI().equals(GudBuilder.XFORMS_NS))) {
				// eactionȊÔƂactionvfeƂčĂ
				Element parent_gud_action = dom.createElementNS(GudBuilder.GUD_NS, "action");
				// ev:eventeactionvfɃRs[
				parent_gud_action.setAttributeNS(GudBuilder.EVENT_NS, "ev:event", gud_action.getAttributeNS(GudBuilder.EVENT_NS, "event"));
				gud_action.removeAttributeNS(GudBuilder.EVENT_NS, "event");
				parent_gud_action.setAttribute("name", "action");
				parent_gud_action.appendChild(gud_action);
				gud_action = parent_gud_action;
				this.current = null;
			}
		}

		//setvalue messagêƂ͎qpcdataRs[邽߂currentƂ
		if(xforms_action.getLocalName().equals(ACTION_SETVALUE)) {
			this.current = gud_action;
		} else if(xforms_action.getLocalName().equals(ACTION_MESSAGE)) {
			this.current = gud_action;
		}
		
		
		df.appendChild(gud_action);
		return df;
	}

}
