package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author nakajo
 */
public class Submit2ButtonTest extends TestCase {
	
	/**
	 * xformssubmitvfgudbuttonvfɕϊB
	 * submission͎qvfsendvfsubmissionƂēWJB
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "submit", null);
		Element submit = simpleDoc.getDocumentElement();
		submit.setAttribute("submission", "getcard");
		
		Submit2Button submit2button = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "button");
				
				NodeList children = node.getChildNodes();
				assertEquals("child node length check", children.getLength(), 1);
				Node send = children.item(0);
				assertEquals("child node name check", send.getLocalName(), "send");
				
				
				NamedNodeMap attrs = send.getAttributes();
				assertEquals("attr length check", attrs.getLength(), 2);
				Node event = attrs.getNamedItemNS(GudBuilder.EVENT_NS, "event");
				Node submission = attrs.getNamedItem("submission");
				assertEquals("event prefix check", event.getPrefix(), "ev");
				assertEquals("submission has same value check", submission.getNodeValue(), "getcard");
				
				assertTrue("current is not null check", t.getCurrentElement() != null);
			}
		};

		submit2button.apply(submit, mockOperation);
	}


	/**
	 * localnamesubmitȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testNotXFormsTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "trriger", null);
		Element submit = simpleDoc.getDocumentElement();
		submit.setAttribute("submission", "getcard");

		Submit2Button submit2button = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		submit2button.apply(submit, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * NSxformsȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testWrongNS() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "trriger", null);
		Element submit = simpleDoc.getDocumentElement();
		submit.setAttribute("submission", "getcard");

		Submit2Button submit2button = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		submit2button.apply(submit, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	class MockTransformer extends Submit2Button {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
