package jp.haw.grain.transform.xpath;

import java.io.ByteArrayInputStream;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.xpath.XPathByteCodeElement;
import jp.haw.grain.xpath.XPathByteCodeElementInterface;
import jp.haw.grain.xpath.compiler.ASTXPathExpression;
import jp.haw.grain.xpath.compiler.ParseException;
import jp.haw.grain.xpath.compiler.XPathParser;
import jp.haw.grain.xpath.compiler.XPathParserVisitor;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathExprCompiler {
	protected XPathParser parser;

	public XPathExprCompiler() {
		this.parser = new XPathParser(new ByteArrayInputStream(new byte[0]));
		this.parser.disable_tracing();
	}

	/**
	 * w肳ꂽXPathRpC܂B
	 * RpCʂ̃m[hZbgnꂽDocumentDocumentFragmentƂĕԂ܂B
	 * 
	 * @param xpath
	 * @param ownerDoc
	 * @return
	 * @throws ParseException
	 */
	public Node compile(String xpath, Document ownerDoc) throws ParseException {
		parser.ReInit(new ByteArrayInputStream(xpath.getBytes()));
		XPathParserVisitor visitor = new GudXPathVisitor(ownerDoc);
		ASTXPathExpression node = parser.XPathExpression();
		XPathByteCodeElementInterface byteCodeElement = (XPathByteCodeElementInterface) node.jjtAccept(visitor, null);
		
		Element exprRoot = ownerDoc.createElementNS(GudBuilder.XPATH_NS, XPathByteCodeElement.XPATH_EXPR_ROOT_NODE_NAME);
		exprRoot.appendChild(optimizeStack(byteCodeElement, ownerDoc));
		return exprRoot;
	}

	/**
	 * ͖؂X^bNɐςނ߂ɍœK܂B
	 * 
	 * @param element
	 * @param doc
	 * @return
	 */
	protected DocumentFragment optimizeStack(XPathByteCodeElementInterface element, Document doc) {
		DocumentFragment df = doc.createDocumentFragment();
		_optimizeStack(element, df);
		
		return df;
	}
	
	private void _optimizeStack(XPathByteCodeElementInterface element, DocumentFragment df) {
		if(element.getByteCodeType() == XPathByteCodeElementInterface.BYTE_CODE_TYPE_VALUE) {
			df.appendChild(element.getElement());
			return;
		}

		if(element.getByteCodeType() == XPathByteCodeElementInterface.BYTE_CODE_TYPE_CLOSURE) {
			Element owner = element.getElement();
			if(element.hasChildNodes()) {
				NodeList closureChildren = element.getChildNodes();
				for(int i=0; i<closureChildren.getLength(); i++) {
					DocumentFragment closureDf = optimizeStack((XPathByteCodeElement)closureChildren.item(i), df.getOwnerDocument());
					owner.appendChild(closureDf);
				}
			}
			df.appendChild(owner);
			return;
		}
		
		if(element.hasChildNodes()) {
			NodeList children = element.getChildNodes();
			for(int i=0; i<children.getLength(); i++) {
				_optimizeStack((XPathByteCodeElementInterface)children.item(i), df);
			}
		}

		if(element.getByteCodeType() == XPathByteCodeElementInterface.BYTE_CODE_TYPE_EXPR) {
			df.appendChild(element.getElement());
		}
	}
}
