package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author nakajo
 */
public class Body2View extends AbstractTransformer {

	protected GudBuilder builder;
	protected Element current;
	
	public Body2View(GudBuilder builder) {
		this.builder = builder;
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#isTarget(org.w3c.dom.Node)
	 */
	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		
		Element e = (Element)node;
		if(e.getNamespaceURI() != GudBuilder.XHTML_NS) return false;
		
		return e.getLocalName().equals("body");
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#transform(org.w3c.dom.Node, org.w3c.dom.Document)
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		DocumentFragment df = dom.createDocumentFragment();
		Element gud_view = dom.createElementNS(GudBuilder.GUD_NS, "view");
		
		//title擾
		//xhtml:titleTāA1Ԗڂ̒lƂBŏɒ`ĂtitlêݓKpÂق͖
		Document xhtmlDoc = node.getOwnerDocument();
		NodeList titleList = xhtmlDoc.getElementsByTagNameNS(GudBuilder.XHTML_NS, "title");
		if(titleList.getLength() > 0) {
			//^Cg^OȂ͕񂵂ȂƌߑłBBB
			gud_view.setAttribute("title", titleList.item(0).getFirstChild().getNodeValue()); 
		}
		
		Util.copyAttributes((Element)node, gud_view);
		
		df.appendChild(gud_view);
		this.current = gud_view;
		
		return df;
		
	}
	
	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#getCurrentNode()
	 */
	public Element getCurrentElement() {
		// TODO ꂽ\bhEX^u
		return this.current;
	}
	
}
