package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * @author nakajo
 */
public class Html2Form extends AbstractTransformer {

	protected GudBuilder builder;
	protected Element current;

	public Html2Form(GudBuilder builder) {
		this.builder = builder;
	}
	
	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		if(!GudBuilder.XHTML_NS.equals(node.getNamespaceURI())) return false;
		
		return node.getLocalName().equals("html");
	}

	//ȂɂȂB
	public DocumentFragment transform() {
		Element form = builder.getGudDoc().getDocumentElement();

		//Rs[
		Util.copyAttributes((Element)node, form);
		
		return null;
	}
	
}
