package jp.haw.grain.framework.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

/**
 * @author nakajo
 */
public class Util {

	/**
	 * oCgzMime.base64ɃGR[h܂B
	 * @param data
	 * @return
	 * @throws IOException
	 * @throws UnsupportedEncodingException
	 * @throws MessagingException
	 */
	public static String encodeBase64(byte[] data)
	  throws IOException, UnsupportedEncodingException, MessagingException {
	  ByteArrayOutputStream bao = new ByteArrayOutputStream();
	  OutputStream out = MimeUtility.encode(bao, "base64");
	  out.write(data);
	  out.close();
	  return bao.toString("ISO-8859-1");
	}

	/**
	 * w肳ꂽMime.base64oCgzɃfR[h܂B
	 * @param str
	 * @return
	 * @throws IOException
	 * @throws UnsupportedEncodingException
	 * @throws MessagingException
	 */
	public static byte[] decodeBase64(String str)
	  throws IOException, UnsupportedEncodingException, MessagingException {
	  InputStream in = MimeUtility.decode(new ByteArrayInputStream(str.getBytes("ISO-8859-1")), "base64");
	  byte[] buf = new byte[1024];
	  ByteArrayOutputStream out = new ByteArrayOutputStream();
	  int len;
	  while ((len = in.read(buf)) != -1) {
		out.write(buf, 0, len);
	  }
	  return out.toByteArray();
	}
	

	public static void dumpBytes(byte[] b){
		int of = 0;
		int len = 16;
		int max = b.length + len;
		int i = 0;
		while (of < max) {
			System.out.println("*** dump[" + i +"] : " + toHex(b, of, len) + "---" + toAscii(b, of, len));
			of += len;            
		}        
	}
    
    
	public static String toAscii(byte[] data, int offset, int len) {
		StringBuffer buf = new StringBuffer();
		for (int i = offset; i < offset + len; ++i) {
			if (i >= data.length) {
				buf.append("   ");
				continue;
			}
			int c = 0xff & data[i];
			if (c < 0x20 || 0x80 < c) {
				buf.append("\\").append(toHex(data[i]));
			} else {
				buf.append("  ").append((char)c);
			}
		}
		return buf.toString();
	}
    
	public static String toHex(byte[] data, int offset, int len) {
		StringBuffer buf = new StringBuffer();
		for (int i = offset; i < offset + len; ++i) {
			if (i % 4 == 0) buf.append(" ");
			if (i >= data.length) {
				buf.append("  ");
				continue;
			}
			buf.append(toHex(data[i]));
		}
		return buf.toString();
	}
    
	public static String toHex(byte data) {
		char[] hex = new char[2];
		hex[0] = getHexChar((data & 0xF0) >>> 4);        
		hex[1] = getHexChar(data & 0x0F);
		return String.valueOf(hex);
	}
    
	public static char getHexChar(int val) {
		if (val < 10) {
			return (char)('0' + val);
		} else {
			return (char)('a' + (val - 10));
		}
	}
}
