package jp.haw.grain.transform;

import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.transformer.TriggerAndSubmitChildCopy;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
	//<xforms:trigger style="display:block">
	///<xforms:label>Get current temperature</xforms:label>
	//<xforms:action ev:event="DOMActivate">
	//<xforms:toggle case="response" />
	//</xforms:action>
	//</xforms:trigger>
 * @author nakajo
 */
public class TriggerAndSubmitChildCopyTest extends TestCase {

	/**
	 * ctriggervfϊB
	 *
	 */
	public void testParentTrigger() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "trigger", null);
		Element trigger = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element action = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "action");
		Attr event = simpleDoc.createAttributeNS(GudBuilder.EVENT_NS, "event");
		event.setPrefix("ev");
		Element toggle = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "toggle");
		
		trigger.setAttribute("style", "display:block");
		Text text = simpleDoc.createTextNode("Get current temperature");
		label.appendChild(text);
		
		event.setNodeValue("DOMActivate");
		action.setAttributeNodeNS(event);
		toggle.setAttribute("case", "response");
		
		trigger.appendChild(label);
		trigger.appendChild(action);
		action.appendChild(toggle);
		
		TriggerAndSubmitChildCopy tscopy = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "label");
				assertEquals("NS is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tscopy.apply(label, mockOperation);

		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "action");
				assertEquals("NS is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				
				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 1);
				Node event = attrs.item(0);
				assertEquals("prefix check", event.getPrefix(), "ev");
				assertEquals("attr has same value check", event.getNodeValue(), "DOMActivate");
				
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tscopy.apply(action, mockOperation);

		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "toggle");
				assertEquals("NS is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				
				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 1);
				Node caseAttr = attrs.getNamedItem("case");
				assertEquals("attr has same value check", caseAttr.getNodeValue(), "response");
				
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tscopy.apply(toggle, mockOperation);

		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), null);
				assertEquals("same text check", node.getTextContent(), "Get current temperature");
				
				assertTrue("current is null check", t.getCurrentElement() == null);
			}
		};

		tscopy.apply(text, mockOperation);
	}

	/**
	 * csubmitvfϊB
	 *
	 */
	public void testParentSubmit() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "submit", null);
		Element submit = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element action = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "action");
		Attr event = simpleDoc.createAttributeNS(GudBuilder.EVENT_NS, "ev:event");
		Element toggle = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "toggle");
		
		submit.setAttribute("style", "display:block");
		Text text = simpleDoc.createTextNode("Get current temperature");
		label.appendChild(text);
		event.setNodeValue("DOMActivate");
		action.setAttributeNodeNS(event);
		toggle.setAttribute("case", "response");
		
		submit.appendChild(label);
		submit.appendChild(action);
		action.appendChild(toggle);
		
		TriggerAndSubmitChildCopy tscopy = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "label");
				assertEquals("NS is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tscopy.apply(label, mockOperation);

		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "action");
				assertEquals("NS is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				
				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 1);
				Node event = attrs.getNamedItemNS(GudBuilder.EVENT_NS, "event");
				assertEquals("prefix check", event.getPrefix(), "ev");
				assertEquals("attr has same value check", event.getNodeValue(), "DOMActivate");
				
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tscopy.apply(action, mockOperation);

		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "toggle");
				assertEquals("NS is gud check", node.getNamespaceURI(), GudBuilder.GUD_NS);
				
				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 1);
				Node caseAttr = attrs.getNamedItem("case");
				assertEquals("attr has same value check", caseAttr.getNodeValue(), "response");
				
				assertTrue("current is null check", t.getCurrentElement() != null);
			}
		};

		tscopy.apply(toggle, mockOperation);

		mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);

				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), null);
				assertEquals("same text check", node.getTextContent(), "Get current temperature");
				
				assertTrue("current is null check", t.getCurrentElement() == null);
			}
		};

		tscopy.apply(text, mockOperation);
	}

	/**
	 * c悪triggerłsubmitłȂvfB
	 *
	 */
	public void testWrongLocalname() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "input", null);
		Element input = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element action = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "action");
		Attr event = simpleDoc.createAttributeNS(GudBuilder.EVENT_NS, "ev:event");
		Element toggle = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "toggle");
		
		input.setAttribute("style", "display:block");
		label.setTextContent("Get current temperature");
		event.setNodeValue("DOMActivate");
		action.setAttributeNodeNS(event);
		toggle.setAttribute("case", "response");
		
		input.appendChild(label);
		input.appendChild(action);
		action.appendChild(toggle);
		
		TriggerAndSubmitChildCopy tscopy = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		tscopy.apply(label, mockOperation);
		mockOperation.createChildNodeOperation();
		tscopy.apply(action, mockOperation);
		mockOperation.createChildNodeOperation();
		tscopy.apply(toggle, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * NSXFormsȂB
	 *
	 */
	public void testWrongNS() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "trigger", null);
		Element trigger = simpleDoc.getDocumentElement();
		Element label = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "label");
		Element action = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "action");
		Attr event = simpleDoc.createAttributeNS(GudBuilder.EVENT_NS, "ev:event");
		Element toggle = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "toggle");
		
		trigger.setAttribute("style", "display:block");
		trigger.setTextContent("Get current temperature");
		event.setNodeValue("DOMActivate");
		action.setAttributeNodeNS(event);
		toggle.setAttribute("case", "response");
		
		trigger.appendChild(label);
		trigger.appendChild(action);
		action.appendChild(toggle);
		
		TriggerAndSubmitChildCopy tscopy = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		tscopy.apply(label, mockOperation);
		mockOperation.createChildNodeOperation();
		tscopy.apply(action, mockOperation);
		mockOperation.createChildNodeOperation();
		tscopy.apply(toggle, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	class MockTransformer extends TriggerAndSubmitChildCopy {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}

		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
