package jp.haw.grain.transform.util;

import org.w3c.dom.Node;

/**
 * Ώۃm[h킷NXłB
 * namespacelocalnameł̂݃`FbNȒPequals񋟂܂B
 * `FbNΏۂorg.w3c.dom.NodełȂ΂܂B
 * 
 * 
 * ̃IuWFNgnamespaceURIlocalnamenull̂ƂfalseԂ܂B
 * ͂2null̏ꍇ͑Ώۂ̃^OvfӂɌłȂłB
 * @author nakajo
 */
public class TargetNode {
		
	protected String namespaceURI;
	protected String localname;
	protected short nodeType;
		
	/**
	 * RXgN^
	 * <code>Node</code>NamespaceURI, localname, nodeType킷TargetNodeIuWFNg𐶐܂B
	 * @param node
	 */
	public TargetNode(Node node) {
		this.namespaceURI = node.getNamespaceURI();
		this.localname = node.getLocalName();
		this.nodeType = node.getNodeType();
	}
	
	/**
	 * RXgN^
	 * @param namespaceURI
	 * @param localname
	 * @param type
	 */
	public TargetNode(String namespaceURI, String localname, short type) {
		this.namespaceURI = namespaceURI;
		this.localname = localname;
		this.nodeType = type;
	}
	
	/**
	 * nodẽIuWFNgł킳m[hƈv邩ǂԂ܂B
	 */
	public boolean equals(Object obj) {
		if(!(obj instanceof Node)) return false;
		Node node =(Node)obj;
		if(node.getNodeType() != this.nodeType) return false;
		
		if(node == null) return false;
			
		if(this.namespaceURI == null) return false;
		if(this.localname == null) return false;
			
		return (this.namespaceURI.equals(node.getNamespaceURI())) && (this.localname.equals(node.getLocalName()));
			
	}
	/**
	 * @return
	 */
	public String getLocalname() {
		return localname;
	}

	/**
	 * @return
	 */
	public String getNamespaceURI() {
		return namespaceURI;
	}

	/**
	 * @return
	 */
	public short getNodeType() {
		return nodeType;
	}

}