package jp.haw.grain.transform.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Node;

/**
 * @author nakajo
 */
public class NamespaceMap {

	public static final String EMPTY_URI = "";
	public static final String EMPTY_PREFIX = "EMPTY_PREFIX";
	
	protected NamespaceMap parent;
	protected List children;
	protected Map uriMap;
	protected Node ownerNode;
	
	public NamespaceMap(Node owner) {
		this.ownerNode = owner;
		this.uriMap = new HashMap();
		this.children = new ArrayList();
	}
	
	public void addUriPrefix(String uri, String prefix) {
		this.uriMap.put(uri, prefix);
	}
	
	public boolean contains(String uri) {
		return this.uriMap.containsKey(uri);
	}
	
	public String getPrefix(String uri) {
		String prefix = this.uriMap.get(uri).toString();
		if(EMPTY_PREFIX.equals(prefix)) return null;
		
		return prefix;
	}
	
	public NamespaceMap getParent() {
		return this.parent;
	}
	
	public Node getOwnerNode() {
		return this.ownerNode;
	}
	
	public void addChild(NamespaceMap child) {
		child.setParent(this);
		this.children.add(child);
	}
	
	public List getChildren() {
		return this.children;
	}
	
	public int size() {
		return this.uriMap.keySet().size();
	}
	
	public boolean hasChildren() {
		return this.children.size() > 0;
	}
	
	public boolean hasMapping() {
		return size() > 0;
	}
	
	/**
	 * @param map
	 */
	public void setParent(NamespaceMap map) {
		parent = map;
	}
	
	public String toString() {
		return this.getClass().getName()+"["+this.ownerNode.getNodeName()+"]";
	}

}
