/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.container.internal.J2EEContainerCapability;
import org.codehaus.cargo.container.spi.AbstractContainer;
import org.codehaus.cargo.container.spi.ContainerConfiguration;

public abstract class AbstractOrionContainer
extends AbstractContainer
implements Container {
    private ContainerCapability capability = new J2EEContainerCapability();

    private void init() {
        if (this.getConfiguration().getPropertyValue("cargo.orion.rmi.port") == null) {
            this.getConfiguration().setProperty("cargo.orion.rmi.port", "25791");
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public final void doStop(Java java) {
        this.init();
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getHomeDir());
        fileSet.createInclude().setName(this.getContainerClasspathIncludes());
        classpath.addFileset(fileSet);
        java.setClassname(this.getStopClassname());
        String shutdownURL = "ormi://" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.orion.rmi.port") + "/";
        this.getMonitor().debug("Shutdown URL [" + shutdownURL + "]", this.getClass().getName());
        java.createArg().setValue(shutdownURL);
        java.createArg().setValue("cargo");
        java.createArg().setValue("cargo");
        java.createArg().setValue("-shutdown");
        AntContainerExecutorThread orionRunner = new AntContainerExecutorThread(java);
        orionRunner.start();
    }

    public final void doStart(Java java) throws Exception {
        this.init();
        ContainerConfiguration orionConfiguration = (ContainerConfiguration)this.getConfiguration();
        this.verify(orionConfiguration);
        orionConfiguration.configure();
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getHomeDir());
        fileSet.createInclude().setName(this.getContainerClasspathIncludes());
        classpath.addFileset(fileSet);
        this.addToolsJarToClasspath(classpath);
        java.setClassname(this.getStartClassname());
        java.createArg().setValue("-config");
        java.createArg().setFile(new File(this.getConfiguration().getDir(), "conf/server.xml"));
        AntContainerExecutorThread orionRunner = new AntContainerExecutorThread(java);
        orionRunner.start();
    }

    protected abstract String getStartClassname();

    protected abstract String getStopClassname();

    protected abstract String getContainerClasspathIncludes();

    private void verify(ContainerConfiguration configuration) {
        this.verifyHomeDir();
        configuration.verifyProperties();
    }
}

