/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import org.mortbay.http.HttpFields;
import org.mortbay.util.Code;
import org.mortbay.util.LineInput;

public class ChunkingInputStream
extends InputStream {
    int _chunkSize = 0;
    HttpFields _trailer = null;
    LineInput _in;

    public ChunkingInputStream(LineInput in) {
        this._in = in;
    }

    public void resetStream() {
        this._chunkSize = 0;
        this._trailer = null;
    }

    public int read() throws IOException {
        int b = -1;
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        b = this._in.read();
        this._chunkSize = b < 0 ? -1 : this._chunkSize - 1;
        return b;
    }

    public int read(byte[] b) throws IOException {
        int len = b.length;
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        if (len > this._chunkSize) {
            len = this._chunkSize;
        }
        this._chunkSize = (len = this._in.read(b, 0, len)) < 0 ? -1 : this._chunkSize - len;
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1;
        }
        if (len > this._chunkSize) {
            len = this._chunkSize;
        }
        this._chunkSize = (len = this._in.read(b, off, len)) < 0 ? -1 : this._chunkSize - len;
        return len;
    }

    public long skip(long len) throws IOException {
        if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
            return -1L;
        }
        if (len > (long)this._chunkSize) {
            len = this._chunkSize;
        }
        this._chunkSize = (len = this._in.skip(len)) < 0L ? -1 : this._chunkSize - (int)len;
        return len;
    }

    public int available() throws IOException {
        int len = this._in.available();
        if (len <= this._chunkSize || this._chunkSize == 0) {
            return len;
        }
        return this._chunkSize;
    }

    public void close() throws IOException {
        this._chunkSize = -1;
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() {
        Code.notImplemented();
    }

    public void mark(int readlimit) {
        Code.notImplemented();
    }

    private int getChunkSize() throws IOException {
        if (this._chunkSize < 0) {
            return -1;
        }
        this._trailer = null;
        this._chunkSize = -1;
        LineInput.LineBuffer line_buffer = this._in.readLineBuffer();
        while (line_buffer != null && line_buffer.size == 0) {
            line_buffer = this._in.readLineBuffer();
        }
        if (line_buffer == null) {
            Code.warning("EOF");
            return -1;
        }
        String line = new String(line_buffer.buffer, 0, line_buffer.size);
        int i = line.indexOf(59);
        if (i > 0) {
            line = line.substring(0, i).trim();
        }
        try {
            this._chunkSize = Integer.parseInt(line, 16);
        }
        catch (NumberFormatException e) {
            this._chunkSize = -1;
            Code.warning("Bad Chunk:" + line);
            Code.debug(e);
        }
        if (this._chunkSize == 0) {
            this._chunkSize = -1;
            this._trailer = new HttpFields();
            this._trailer.read(this._in);
        }
        return this._chunkSize;
    }
}

